package com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement;
/**
 * Created by Bao Hongbin on 2021-12-17 10:27.
 */

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @program: crm-dms
 * @description: 签署栏对账要素表
 * @author: Bao Hongbin
 * @create: 2021-12-17 10:27
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignatureColumn", description = "签署栏对账要素表")
@TableName("dms_reconciliation_signature_column")
@Entity
@Table(name = "dms_reconciliation_signature_column")
@org.hibernate.annotations.Table(appliesTo = "dms_reconciliation_signature_column", comment = "对账函头部信息要素表")
public class SignatureColumn extends ReconciliationElementEntity{

  /**
   * 厂商编号
   *
   */
  @ApiModelProperty(name = "manufacturerCode", value = "厂商编号")
  @TableField(value = "manufacturer_code")
  @Column(name = "manufacturer_code", nullable = false, columnDefinition = "varchar(64) COMMENT '厂商编号'")
  private String manufacturerCode;

  /**
   * 厂商名称
   *
   */
  @ApiModelProperty(name = "manufacturerName", value = "厂商名称")
  @TableField(value = "manufacturer_name")
  @Column(name = "manufacturer_name", nullable = false, columnDefinition = "varchar(128) COMMENT '厂商名称'")
  private String manufacturerName;
}
