package com.biz.crm.dms.business.reconciliation.local.entity.reconciliationletter;
/**
 * Created by Bao Hongbin on 2021-12-21 16:57.
 */

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.dms.business.reconciliation.sdk.enums.ReconciliationLetterOperateType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @program: crm-dms
 * @description: 对账往来记录表
 * @author: Bao Hongbin
 * @create: 2021-12-21 16:57
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ReconciliationContactRecord", description = "对账往来记录表")
@TableName("dms_reconciliation_contact_record")
@Entity
@Table(name = "dms_reconciliation_contact_record")
@org.hibernate.annotations.Table(appliesTo = "dms_reconciliation_contact_record", comment = "对账往来记录表")
public class ReconciliationContactRecord extends TenantOpEntity {
  /**
   * 对账函编码
   */
  @ApiModelProperty("对账函编码")
  @TableField(value = "reconciliation_letter_code")
  @Column(name = "reconciliation_letter_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 对账函编码 '")
  private String reconciliationLetterCode;

  /**
   * 岗位编码
   */
  @ApiModelProperty("岗位编码")
  @TableField(value = "post_code")
  @Column(name = "post_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 岗位编码 '")
  private String postCode;
  /**
   * 岗位名称
   */
  @ApiModelProperty("岗位名称")
  @TableField(value = "post_name")
  @Column(name = "post_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 岗位名称 '")
  private String postName;
  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  @TableField(value = "org_code")
  @Column(name = "org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 组织编码 '")
  private String orgCode;
  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  @TableField(value = "org_name")
  @Column(name = "org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 组织名称 '")
  private String orgName;

  /**
   * 操作动作类型
   */
  @ApiModelProperty("操作动作类型")
  @TableField(value = "reconciliation_letter_operate_type")
  @Column(name = "reconciliation_letter_operate_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 操作动作类型 '")
  private ReconciliationLetterOperateType reconciliationLetterOperateType;

  /**
   * 沟通内容
   */
  @ApiModelProperty("沟通内容")
  @TableField(value = "content")
  @Column(name = "content", length = 500, columnDefinition = "VARCHAR(500) COMMENT ' 沟通内容 '")
  private String content;

}
