package com.biz.crm.dms.business.reconciliation.local.entity.reconciliationletter;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @program: crm-dms
 * @description: 对账往来记录附件表
 * @author: Bao Hongbin
 * @create: 2021-12-21 16:57
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ReconciliationContactRecordFile", description = "对账往来记录附件表")
@Entity
@TableName("dms_reconciliation_contact_record_files")
@Table(name = "dms_reconciliation_contact_record_files")
@org.hibernate.annotations.Table(appliesTo = "dms_reconciliation_contact_record_files", comment = "对账往来记录附件表")
public class ReconciliationContactRecordFile extends TenantEntity {
  private static final long serialVersionUID = 8382252416222138368L;
  /**
   * 对账往来记录Id
   */
  @ApiModelProperty(name = "reconciliation_contact_record_Id", value = "对账往来记录Id", required = true)
  @Column(name = "reconciliation_contact_record_Id", length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '对账往来记录Id'")
  private String reconciliationContactRecordId;
  /**
   * 文件名
   */
  @ApiModelProperty(name = "file_name", value = "文件名", required = true)
  @Column(name = "file_name", length = 128, columnDefinition = "VARCHAR(128) NOT NULL COMMENT '文件名'")
  private String fileName;
  /**
   * 文件唯一标识
   */
  @ApiModelProperty(name = "object_name", value = "文件唯一标识", required = true)
  @Column(name = "object_name", length = 200, columnDefinition = "VARCHAR(200) NOT NULL COMMENT '文件唯一标识'")
  private String objectName;
  /**
   * 文件全路径
   */
  @ApiModelProperty(name = "url", value = "文件全路径", required = true)
  @Column(name = "url", length = 200, columnDefinition = "VARCHAR(200) NOT NULL COMMENT '文件全路径'")
  private String url;
  /**
   * 文件路径
   */
  @ApiModelProperty(name = "url_path", value = "文件路径", required = true)
  @Column(name = "url_path", length = 200, columnDefinition = "VARCHAR(200) NOT NULL COMMENT '文件路径'")
  private String urlPath;
  /**
   * 域名
   */
  @ApiModelProperty(name = "url_path_prefix", value = "域名", required = true)
  @Column(name = "url_path_prefix", length = 128, columnDefinition = "VARCHAR(128) NOT NULL COMMENT '域名'")
  private String urlPathPrefix;
}
