package com.biz.crm.dms.business.reconciliation.local.entity.reconciliationletter;
/**
 * Created by Bao Hongbin on 2021-12-21 16:27.
 */

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.dms.business.reconciliation.sdk.enums.ReconciliationLetterStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @program: crm-dms
 * @description: 对账函表
 * @author: Bao Hongbin
 * @create: 2021-12-21 16:27
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ReconciliationLetter", description = "对账函表")
@TableName("dms_reconciliation_letter")
@Entity
@Table(name = "dms_reconciliation_letter")
@org.hibernate.annotations.Table(appliesTo = "dms_reconciliation_letter", comment = "对账函表")
public class ReconciliationLetter extends TenantFlagOpEntity {

  /**
   * 对账函编码
   */
  @ApiModelProperty("对账函编码")
  @TableField(value = "reconciliation_letter_code")
  @Column(name = "reconciliation_letter_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 对账函编码 '")
  private String reconciliationLetterCode;

  /**
   * 对账函状态
   */
  @ApiModelProperty("对账函状态")
  @TableField(value = "reconciliation_letter_status")
  @Column(name = "reconciliation_letter_status", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 对账函状态 '")
  private ReconciliationLetterStatus reconciliationLetterStatus;

  /**
   * 对账规则（模板）编码
   */
  @ApiModelProperty("对账规则（模板）编码")
  @TableField(value = "reconciliation_template_code")
  @Column(name = "reconciliation_template_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 对账规则（模板）编码 '")
  private String reconciliationTemplateCode;

  /**
   * 对账规则（模板）名称
   */
  @ApiModelProperty("对账规则（模板）名称")
  @TableField(value = "reconciliation_template_name")
  @Column(name = "reconciliation_template_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 对账规则（模板）名称 '")
  private String reconciliationTemplateName;

  /**
   * 计算开始时间
   */
  @ApiModelProperty("计算开始时间")
  @TableField(value = "calculation_start_time")
  @Column(name = "calculation_start_time", nullable = false, length = 20, columnDefinition = "datetime COMMENT '计算开始时间'")
  private Date calculationStartTime;

  /**
   * 计算结束时间
   */
  @ApiModelProperty("计算结束时间")
  @TableField(value = "calculation_end_time")
  @Column(name = "calculation_end_time", nullable = false, length = 20, columnDefinition = "datetime COMMENT '计算结束时间'")
  private Date calculationEndTime;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @TableField(value = "customer_code")
  @Column(name = "customer_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户编码 '")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @TableField(value = "customer_name")
  @Column(name = "customer_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户名称 '")
  private String customerName;

  /**
   * 客户确认时间
   */
  @ApiModelProperty("客户确认时间")
  @TableField(value = "confirm_time")
  @Column(name = "confirm_time", length = 20, columnDefinition = "datetime COMMENT '客户确认时间'")
  private Date confirmTime;
}
