package com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-17 20:09.
 */

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.dms.business.reconciliation.sdk.enums.GenerationCycleType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账模板实体
 * @author: Bao Hongbin
 * @create: 2021-12-17 20:09
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ReconciliationTemplate", description = "对账规则（模板）实体")
@TableName("dms_reconciliation_template")
@Entity
@Table(name = "dms_reconciliation_template")
@org.hibernate.annotations.Table(appliesTo = "dms_reconciliation_template", comment = "对账模板表")
public class ReconciliationTemplate extends TenantFlagOpEntity {
  /**
   * 对账规则（模板）编码
   */
  @ApiModelProperty("对账规则（模板）编码")
  @TableField(value = "reconciliation_template_code")
  @Column(name = "reconciliation_template_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 对账规则（模板）编码 '")
  private String reconciliationTemplateCode;

  /**
   * 对账规则（模板）名称
   */
  @ApiModelProperty("对账规则（模板）名称")
  @TableField(value = "reconciliation_template_name")
  @Column(name = "reconciliation_template_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 对账规则（模板）名称 '")
  private String reconciliationTemplateName;

  /**
   * 有效开始时间
   */
  @ApiModelProperty("有效开始时间")
  @TableField(value = "validity_start_time")
  @Column(name = "validity_start_time", nullable = false, length = 20, columnDefinition = "datetime COMMENT '有效开始时间'")
  private Date validityStartTime;

  /**
   * 有效结束时间
   */
  @ApiModelProperty("有效结束时间")
  @TableField(value = "validity_end_time")
  @Column(name = "validity_end_time", nullable = false, length = 20, columnDefinition = "datetime COMMENT '有效结束时间'")
  private Date validityEndTime;

  /**
   * 生成周期类型
   */
  @ApiModelProperty("生成周期类型")
  @TableField(value = "generation_cycle_type")
  @Column(name = "generation_cycle_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 生成周期类型 '")
  private GenerationCycleType generationCycleType;

  /**
   * 生成时间
   * 对账函计算期结束后的第几天生成
   */
  @ApiModelProperty("生成时间")
  @TableField(value = "generation_time")
  @Column(name = "generation_time", length = 3, columnDefinition = "INT(3) COMMENT '生成时间'")
  private Integer generationTime;

  /**
   * 对账函计算时间
   */
  @ApiModelProperty("对账函计算时间")
  @Transient
  @TableField(exist = false)
  private List<ReconciliationLetterCalculationTime> reconciliationLetterCalculationTimes;

  /**
   * 对账规则要素
   */
  @ApiModelProperty("对账规则要素")
  @Transient
  @TableField(exist = false)
  private List<ReconciliationTemplateElement> reconciliationTemplateElements;

  /**
   * 对账规则生效范围
   */
  @ApiModelProperty("对账规则生效范围")
  @Transient
  @TableField(exist = false)
  private List<ReconciliationTemplateRange> reconciliationTemplateRanges;

}
