package com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-18 16:01.
 */

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @program: crm-dms
 * @description: 对账规则要素表
 * @author: Bao Hongbin
 * @create: 2021-12-18 16:01
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ReconciliationTemplateElement", description = "对账规则要素表")
@TableName("dms_reconciliation_template_element")
@Entity
@Table(name = "dms_reconciliation_template_element")
@org.hibernate.annotations.Table(appliesTo = "dms_reconciliation_template_element", comment = "对账规则要素表")
public class ReconciliationTemplateElement extends TenantEntity {

  /**
   * 对账规则（模板）编码
   */
  @ApiModelProperty("对账规则（模板）编码")
  @TableField(value = "reconciliation_template_code")
  @Column(name = "reconciliation_template_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 对账规则（模板）编码 '")
  private String reconciliationTemplateCode;

  /**
   * 要素编码
   */
  @ApiModelProperty("要素编码")
  @TableField(value = "element_code")
  @Column(name = "element_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 要素编码 '")
  private String elementCode;

  /**
   * 要素名称
   */
  @ApiModelProperty("要素名称")
  @TableField(value = "element_name")
  @Column(name = "element_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 要素名称 '")
  private String elementName;

  /**
   * 对账规则中各要素的排序
   */
  @ApiModelProperty("对账规则中各要素的排序")
  @TableField(value = "sort")
  @Column(name = "sort", length = 3, columnDefinition = "INT(3) COMMENT '对账规则中各要素的排序'")
  private Integer sort;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  @TableField(value = "remarks")
  @Column(name = "remarks", length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 备注 '")
  private String remarks;

}
