package com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-18 16:02.
 */

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @program: crm-dms
 * @description: 对账规则生效范围表
 * @author: Bao Hongbin
 * @create: 2021-12-18 16:02
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ReconciliationTemplateRangeInfo", description = "对账规则生效范围表")
@TableName("dms_reconciliation_template_range")
@Entity
@Table(name = "dms_reconciliation_template_range")
@org.hibernate.annotations.Table(appliesTo = "dms_reconciliation_template_range", comment = "对账规则生效范围表")
public class ReconciliationTemplateRange extends TenantEntity {

  /**
   * 对账规则（模板）编码
   */
  @ApiModelProperty("对账规则（模板）编码")
  @TableField(value = "reconciliation_template_code")
  @Column(name = "reconciliation_template_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 对账规则（模板）编码 '")
  private String reconciliationTemplateCode;

  /**
   * 对账规则生效范围类型
   */
  @ApiModelProperty("对账规则生效范围类型")
  @TableField(value = "range_type")
  @Column(name = "range_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 对账规则生效范围类型 '")
  private String rangeType;

  /**
   * 数据编码
   */
  @ApiModelProperty("数据编码")
  @TableField(value = "data_code")
  @Column(name = "data_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 数据编码 '")
  private String dataCode;

  /**
   * 数据名称
   */
  @ApiModelProperty("数据名称")
  @TableField(value = "data_name")
  @Column(name = "data_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 数据名称 '")
  private String dataName;

}
