package com.biz.crm.dms.business.reconciliation.local.repository.reconciliationelement;
/**
 * Created by Bao Hongbin on 2021-12-17 11:06.
 */

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement.CustomerTransactionDetail;
import com.biz.crm.dms.business.reconciliation.local.mapper.reconciliationelement.CustomerTransactionDetailMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 客户往来明细对账要素数据库访问类
 * @author: Bao Hongbin
 * @create: 2021-12-17 11:06
 **/
@Component
public class CustomerTransactionDetailRepository extends ServiceImpl<CustomerTransactionDetailMapper, CustomerTransactionDetail> {
  /**
   * 通过对账函编码查询要素内容
   *
   * @param letterCode 对账函编码
   * @return 客户往来明细对账要素数据
   */
  public List<CustomerTransactionDetail> findListByLetterCode(String letterCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(CustomerTransactionDetail::getTenantCode, tenantCode)
        .eq(CustomerTransactionDetail::getLetterCode, letterCode).list();
  }

  /**
   * 通过对账函编码查询要素内容
   *
   * @param letterCode 对账函编码
   * @return 客户往来明细对账要素数据
   */
  public List<CustomerTransactionDetail> findByLetterCodeAndCustomerCode(String customerCode,String letterCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(CustomerTransactionDetail::getTenantCode, tenantCode)
        .eq(CustomerTransactionDetail::getCustomerCode, customerCode)
        .eq(CustomerTransactionDetail::getLetterCode, letterCode).list();
  }
}
