package com.biz.crm.dms.business.reconciliation.local.repository.reconciliationelement;
/**
 * Created by Bao Hongbin on 2021-12-17 11:06.
 */

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement.HeaderInformation;
import com.biz.crm.dms.business.reconciliation.local.mapper.reconciliationelement.HeaderInformationMapper;
import org.springframework.stereotype.Component;

/**
 * @program: crm-dms
 * @description: 对账函头部信息要素数据库访问类
 * @author: Bao Hongbin
 * @create: 2021-12-17 11:06
 **/
@Component
public class HeaderInformationRepository extends ServiceImpl<HeaderInformationMapper, HeaderInformation> {

  public HeaderInformation findByLetterCode(String letterCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(HeaderInformation::getTenantCode, tenantCode)
        .eq(HeaderInformation::getLetterCode, letterCode).one();
  }

  public HeaderInformation findByLetterCodeAndCustomerCode(String customerCode,String letterCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(HeaderInformation::getTenantCode, tenantCode)
        .eq(HeaderInformation::getCustomerCode, customerCode)
        .eq(HeaderInformation::getLetterCode, letterCode).one();
  }
}
