package com.biz.crm.dms.business.reconciliation.local.repository.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-18 16:51.
 */

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate.ReconciliationLetterCalculationTime;
import com.biz.crm.dms.business.reconciliation.local.mapper.reconciliationtemplate.ReconciliationLetterCalculationTimeMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账函生成时间表数据库访问类
 * @author: Bao Hongbin
 * @create: 2021-12-18 16:51
 **/
@Component
public class ReconciliationLetterCalculationTimeRepository extends ServiceImpl<ReconciliationLetterCalculationTimeMapper, ReconciliationLetterCalculationTime> {

  @Autowired(required = false)
  private ReconciliationLetterCalculationTimeMapper reconciliationLetterCalculationTimeMapper;
  /**
   * 通过对账规则编码查询计算时间
   *
   * @param reconciliationTemplateCode
   * @param tenantCode
   * @return
   */
  public List<ReconciliationLetterCalculationTime> findListByTemplateCode(String reconciliationTemplateCode, String tenantCode) {
    return reconciliationLetterCalculationTimeMapper.findListByTemplateCode(reconciliationTemplateCode, tenantCode);
  }

  /**
   * 通过对账规则编码删除计算时间
   *
   * @param reconciliationTemplateCode
   * @param tenantCode
   */
  public void deleteByTemplateCode(String reconciliationTemplateCode, String tenantCode) {
    this.lambdaUpdate()
        .eq(ReconciliationLetterCalculationTime::getTenantCode, tenantCode)
        .eq(ReconciliationLetterCalculationTime::getReconciliationTemplateCode, reconciliationTemplateCode)
        .remove();
  }

  /**
   * 通过对账规则编码集合查询对账函计算时间集合
   *
   * @param templateCodes
   * @param tenantCode
   * @return
   */
  public List<ReconciliationLetterCalculationTime> findListByTemplateCodes(List<String> templateCodes, String tenantCode) {
    return this.lambdaQuery()
        .eq(ReconciliationLetterCalculationTime::getTenantCode, tenantCode)
        .in(ReconciliationLetterCalculationTime::getReconciliationTemplateCode, templateCodes)
        .list();
  }
}
