package com.biz.crm.dms.business.reconciliation.local.service.reconciliationletter;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterContactRecordDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterManualCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterPaginationDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationletter.ReconciliationLetterVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * Created by Bao Hongbin on 2021-12-21 20:52.
 */
public interface ReconciliationLetterVoService {

  /**
   * 多条件分页查询(可适用于列表分页查询和公用分页弹框)
   *
   * @param pageable
   * @param reconciliationLetterPaginationDto
   * @return
   */
  Page<ReconciliationLetterVo> findByConditions(Pageable pageable, ReconciliationLetterPaginationDto reconciliationLetterPaginationDto);

  /**
   * 按照实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param id
   * @return
   */
  ReconciliationLetterVo findDetailsById(String id);

  /**
   * 相关的创建过程，请注意该创建过程除了可以创建模型中的基本信息以外，还可以对模型中属于OneToMany关联的明细信息一同进行创建注意：
   * 基于模型的创建操作传入的JSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   *
   * @param reconciliationLetterCreateDto
   * @return
   */
  void create(ReconciliationLetterCreateDto reconciliationLetterCreateDto);

  /**
   * 相关的批量创建过程，请注意该创建过程除了可以创建模型中的基本信息以外，还可以对模型中属于OneToMany关联的明细信息一同进行创建注意：
   * 基于模型的创建操作传入的JSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   *
   * @param reconciliationLetterCreateDtos
   * @return
   */
  void createBatch(List<ReconciliationLetterCreateDto> reconciliationLetterCreateDtos);

  /**
   * 根据选择的对账规则和对应的计算时间手动生成生效范围对应的所有客户的对账函
   *
   * @param reconciliationLetterManualCreateDto
   * @return
   */
  void handleManualGenerate(ReconciliationLetterManualCreateDto reconciliationLetterManualCreateDto);

  /**
   * 客户提出疑问
   *
   * @param contactRecordDto
   */
  void handleCustomerQuestion(ReconciliationLetterContactRecordDto contactRecordDto);

  /**
   * 厂商答复
   *
   * @param contactRecordDto
   */
  void handleManufacturerAnswer(ReconciliationLetterContactRecordDto contactRecordDto);

  /**
   * 批量推送对账函
   *
   * @param ids
   */
  void handlePushCustomer(List<String> ids);

  /**
   * 批量自动更新指定对账函内容
   *
   * @param ids
   */
  void updateByIds(List<String> ids);

  /**
   * 批量确认对账函
   *
   * @param ids
   */
  void handleCustomerConfirm(List<String> ids);

  /**
   * 批量删除对账函
   *
   * @param ids
   */
  void deleteBatch(List<String> ids);

  /**
   * 根据对账规则编码查询对账函信息
   * @param collect
   * @return
   */
  List<ReconciliationLetterVo> findByTemplateCodes(List<String> collect);

  /**
   * 客户-对账函分页查询
   * @param pageable
   * @param dto
   * @return
   */
  Page<ReconciliationLetterVo> findByReconciliationLetterPaginationDto(Pageable pageable, ReconciliationLetterPaginationDto dto);

  /**
   * 客户-待客户确认对账函数量
   * @param reconciliationLetterPaginationDto
   * @return
   */
  Integer findWaitConfirmationCountByCurrentCustomer(ReconciliationLetterPaginationDto reconciliationLetterPaginationDto);
}
