package com.biz.crm.dms.business.reconciliation.local.service.reconciliationletter.internal;
/**
 * Created by Bao Hongbin on 2021-12-21 20:55.
 */

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.constant.LoginUserConstant;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.reconciliation.local.context.reconciliationelement.ReconciliationElementContext;
import com.biz.crm.dms.business.reconciliation.local.context.reconciliationtemplate.ReconciliationTemplateRangeContext;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationletter.ReconciliationContactRecord;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationletter.ReconciliationContactRecordFile;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationletter.ReconciliationLetter;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationletter.ReconciliationContactRecordFileRepository;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationletter.ReconciliationContactRecordRepository;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationletter.ReconciliationLetterRepository;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationletter.ReconciliationLetterVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateVoService;
import com.biz.crm.dms.business.reconciliation.sdk.common.constant.ReconciliationLetterConstant;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterContactRecordDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterContactRecordFileDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterManualCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterPaginationDto;
import com.biz.crm.dms.business.reconciliation.sdk.enums.ReconciliationLetterOperateType;
import com.biz.crm.dms.business.reconciliation.sdk.enums.ReconciliationLetterStatus;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationelement.ReconciliationElementRegister;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationtemplate.ReconciliationTemplateRangeRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.ReconciliationTemplateRangeInfo.ReconciliationCustomerInfoVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata.AbstractReconciliationElementDataVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationletter.ReconciliationLetterVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationLetterCalculationTimeVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateElementVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateRangeVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @program: crm-dms
 * @description: 对账函服务类
 * @author: Bao Hongbin
 * @create: 2021-12-21 20:55
 **/
@Service
public class ReconciliationLetterVoServiceImpl implements ReconciliationLetterVoService {

  @Autowired(required = false)
  private ReconciliationLetterRepository reconciliationLetterRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private ReconciliationElementContext elementContext;
  @Autowired(required = false)
  private GenerateCodeService generateCode;
  @Autowired(required = false)
  private ReconciliationTemplateVoService templateVoService;
  @Autowired(required = false)
  private ReconciliationTemplateRangeContext rangeContext;
  @Autowired(required = false)
  private ReconciliationContactRecordRepository contactRecordRepository;
  @Autowired(required = false)
  private ReconciliationContactRecordFileRepository contactRecordFileRepository;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  public Page<ReconciliationLetterVo> findByConditions(Pageable pageable, ReconciliationLetterPaginationDto reconciliationLetterPaginationDto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
    ReconciliationLetterPaginationDto dto = Optional.ofNullable(reconciliationLetterPaginationDto).orElse(new ReconciliationLetterPaginationDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    return reconciliationLetterRepository.findByConditions(pageable, dto);
  }

  @Override
  public ReconciliationLetterVo findDetailsById(String id) {
    if (!StringUtils.isNotEmpty(id)) {
      return null;
    }
    //查询数据
    ReconciliationLetterVo reconciliationLetterVo = reconciliationLetterRepository.findDetailsById(id, TenantUtils.getTenantCode());
    ReconciliationTemplateVo reconciliationTemplateVo = templateVoService.findDetailsByCode(reconciliationLetterVo.getReconciliationTemplateCode());
    Validate.notNull(reconciliationTemplateVo,"无法找到对账函对应对账规则信息");
    List<String> elementCodes =
        reconciliationTemplateVo.getElements()
            .stream().map(ReconciliationTemplateElementVo::getElementCode).collect(Collectors.toList());
    if(CollectionUtils.isNotEmpty(elementCodes)){
      //查询对账函的对账要素数据
      List<AbstractReconciliationElementDataVo> elementDataVos = elementCodes.stream().map(elementCode -> {
        ReconciliationElementRegister<?> elementRegister = elementContext.getElementRegisterByCode(elementCode);
        Validate.notNull(elementRegister, "无法找到对账要素注册器");
        return elementRegister.getByLetterCode(reconciliationLetterVo.getReconciliationLetterCode(),reconciliationLetterVo.getCustomerCode());
      }).collect(Collectors.toList());
      reconciliationLetterVo.setElementDataVos(elementDataVos);
    }
    return reconciliationLetterVo;
  }

  @Override
  @Transactional
  public void create(ReconciliationLetterCreateDto reconciliationLetterCreateDto) {
    //1.验证
    validateCreate(reconciliationLetterCreateDto);
    //2.查询是否已经存在重复对账函（判重条件：客户编码+对账规则编码+计算开始日期+计算结束日期）
    ReconciliationLetter reconciliationLetter = reconciliationLetterRepository.findExist(reconciliationLetterCreateDto.getCustomerCode(),
        reconciliationLetterCreateDto.getReconciliationTemplateCode(),
        reconciliationLetterCreateDto.getCalculationStartTime(),
        reconciliationLetterCreateDto.getCalculationEndTime(),
        TenantUtils.getTenantCode());
    if (Objects.isNull(reconciliationLetter)) {
      //2.1如果不存在对账函，则新增；
      reconciliationLetter = nebulaToolkitService.copyObjectByWhiteList(
          reconciliationLetterCreateDto, ReconciliationLetter.class, HashSet.class, ArrayList.class);
      reconciliationLetter.setReconciliationLetterStatus(ReconciliationLetterStatus.WAIT_PUSH);
      reconciliationLetter.setTenantCode(TenantUtils.getTenantCode());
      reconciliationLetter.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      reconciliationLetter.setEnableStatus(
          null != reconciliationLetter.getEnableStatus() ? reconciliationLetter.getEnableStatus() : EnableStatusEnum.ENABLE.getCode());
      //TODO 各业务编码前缀以前可以在系统设置中进行设置，该功能将在后续改造中实现，先设置为固定默认值
      String reconciliationLetterCode = this.generateCode.generateCode(
          ReconciliationLetterConstant.CODE + DateFormatUtils.format(new Date(), "yyyyMM"),
          1, 5, 2, TimeUnit.DAYS).get(0);
      ReconciliationLetter repository = this.reconciliationLetterRepository
          .findByCode(reconciliationLetterCode, TenantUtils.getTenantCode());
      Validate.isTrue(Objects.isNull(repository),"对账编码已存在！");
      reconciliationLetter.setReconciliationLetterCode(reconciliationLetterCode);
      reconciliationLetterRepository.save(reconciliationLetter);
      //生成对账函对账要素数据
      List<String> elementCodes = reconciliationLetterCreateDto.getElementCodes();
      for (String elementCode : elementCodes) {
        ReconciliationElementRegister<?> elementRegister = elementContext.getElementRegisterByCode(elementCode);
        Validate.notNull(elementRegister, "找不到对应的对账要素注册器");
        elementRegister.create(reconciliationLetter.getReconciliationLetterCode(),
            reconciliationLetter.getCustomerCode(),
            reconciliationLetter.getCalculationStartTime(),
            reconciliationLetter.getCalculationEndTime());
      }
    } else if (ReconciliationLetterStatus.WAIT_PUSH.equals(reconciliationLetter.getReconciliationLetterStatus()) ||
        ReconciliationLetterStatus.WAIT_FINANCIAL_REVIEW.equals(reconciliationLetter.getReconciliationLetterStatus())) {
      //2.2如果存在待推送、待财务复核的对账函则重新获取对账要素数据；
      //更新对账函对账要素数据
      List<String> elementCodes = reconciliationLetterCreateDto.getElementCodes();
      //更新要素内容
      for (String elementCode : elementCodes) {
        ReconciliationElementRegister<?> elementRegister = elementContext.getElementRegisterByCode(elementCode);
        Validate.notNull(elementRegister, "找不到对应的对账要素注册器");
        elementRegister.update(reconciliationLetter.getReconciliationLetterCode(), reconciliationLetter.getCustomerCode(), reconciliationLetter.getCalculationStartTime(), reconciliationLetter.getCalculationEndTime());
      }
      reconciliationLetterRepository.updateById(reconciliationLetter);
      //记录更新记录
      saveUpdateRecord(reconciliationLetter,ReconciliationLetterOperateType.UPDATE);

    }
    //2.3如果存在待客户确认、已完成的对账函则不做操作)
  }

  /**
   * 记录对账函更新记录
   *
   * @param reconciliationLetter
   */
  private void saveUpdateRecord(ReconciliationLetter reconciliationLetter,ReconciliationLetterOperateType type) {
    JSONObject loginUserJson = loginUserService.getLoginUserJson();
    ReconciliationContactRecord reconciliationContactRecord = new ReconciliationContactRecord();
    reconciliationContactRecord.setTenantCode(TenantUtils.getTenantCode());
    reconciliationContactRecord.setReconciliationLetterCode(reconciliationLetter.getReconciliationLetterCode());
    reconciliationContactRecord.setPostCode(loginUserJson.getString(LoginUserConstant.FIELD_POST_CODE));
    reconciliationContactRecord.setPostName(loginUserJson.getString(LoginUserConstant.FIELD_POST_NAME));
    reconciliationContactRecord.setOrgCode(loginUserJson.getString(LoginUserConstant.FIELD_ORG_CODE));
    reconciliationContactRecord.setOrgName(loginUserJson.getString(LoginUserConstant.FIELD_ORG_NAME));
    reconciliationContactRecord.setReconciliationLetterOperateType(type);
    contactRecordRepository.save(reconciliationContactRecord);
  }

  @Override
  @Transactional
  public void createBatch(List<ReconciliationLetterCreateDto> reconciliationLetterCreateDtos) {
    Validate.notEmpty(reconciliationLetterCreateDtos, "批量创建对账函时，创建数据不能为空");
    reconciliationLetterCreateDtos.forEach(this::create);
  }

  @Override
  @Transactional
  public void handleManualGenerate(ReconciliationLetterManualCreateDto reconciliationLetterManualCreateDto) {
    //1.验证
    Validate.notNull(reconciliationLetterManualCreateDto, "对账函创建内容不能为空");
    Validate.notBlank(reconciliationLetterManualCreateDto.getReconciliationTemplateCode(), "对账规则编码不能为空");
    Validate.notBlank(reconciliationLetterManualCreateDto.getCalculationTimeId(), "选择的对账规则计算时间id不能为空");
    //2.查询对账规则
    ReconciliationTemplateVo reconciliationTemplateVo =
        templateVoService.findDetailsByCode(reconciliationLetterManualCreateDto.getReconciliationTemplateCode());
    Validate.notNull(reconciliationTemplateVo, "找不到对应对账规则");
    Validate.isTrue(EnableStatusEnum.ENABLE.getCode().equals(reconciliationTemplateVo.getEnableStatus()),
        "对账规则已被禁用，无法生成对应的对账函！");
    //3.获取对账要素
    List<ReconciliationTemplateElementVo> elements = reconciliationTemplateVo.getElements();
    Validate.notEmpty(elements, "无法获取到对账规则对应的对账要素数据");
    List<ReconciliationLetterCalculationTimeVo> calculationTimes = reconciliationTemplateVo.getCalculationTimes();
    Validate.notEmpty(calculationTimes, "无法获取到对账规则对应的对账计算时间数据");
    //4.获取对账计算时间数据
    Map<String, ReconciliationLetterCalculationTimeVo> letterCalculationTimeVoMap =
        calculationTimes.stream().collect(Collectors.toMap(ReconciliationLetterCalculationTimeVo::getId, Function.identity()));
    ReconciliationLetterCalculationTimeVo reconciliationLetterCalculationTimeVo =
        letterCalculationTimeVoMap.get(reconciliationLetterManualCreateDto.getCalculationTimeId());
    Validate.notNull(reconciliationLetterCalculationTimeVo, "无法获取到指定的对账计算时间数据");
    //5.获取生效范围
    List<ReconciliationTemplateRangeVo> ranges = reconciliationTemplateVo.getRanges();
    Validate.notEmpty(ranges, "无法获取到对账规则对应的生效范围数据");
    Map<String, List<ReconciliationTemplateRangeVo>> rangeDataMap = ranges.stream().collect(Collectors.groupingBy(ReconciliationTemplateRangeVo::getRangeType));
    //
    List<ReconciliationCustomerInfoVo> infoVoList = new ArrayList<>();
    rangeDataMap.forEach((key,value)->{
      ReconciliationTemplateRangeRegister rangeRegister = rangeContext.getRangeRegisterByCode(key);
      Validate.notNull(rangeRegister, "找不到对应类型的生效范围注册器");
      List<String> collect = value.stream().map(ReconciliationTemplateRangeVo::getDataCode).collect(Collectors.toList());
      List<ReconciliationCustomerInfoVo> customerInfoByDataCodes = rangeRegister
          .getCustomerInfoByDataCodes(collect);
      if(CollectionUtils.isNotEmpty(customerInfoByDataCodes)){
        infoVoList.addAll(customerInfoByDataCodes);
      }
    });
    if(CollectionUtils.isNotEmpty(infoVoList)){
      List<ReconciliationLetterCreateDto> letterCreateDtos =
          infoVoList.stream().distinct().map(customerInfoVo -> {
            //7.将客户信息转换为对账函创建dto
            ReconciliationLetterCreateDto reconciliationLetterCreateDto = new ReconciliationLetterCreateDto();
            reconciliationLetterCreateDto.setCustomerCode(customerInfoVo.getCustomerCode());
            reconciliationLetterCreateDto.setCustomerName(customerInfoVo.getCustomerName());
            reconciliationLetterCreateDto.setReconciliationTemplateCode(reconciliationTemplateVo.getReconciliationTemplateCode());
            reconciliationLetterCreateDto.setReconciliationTemplateName(reconciliationTemplateVo.getReconciliationTemplateName());
            reconciliationLetterCreateDto.setElementCodes(
                elements.stream().map(ReconciliationTemplateElementVo::getElementCode).collect(Collectors.toList()));
            reconciliationLetterCreateDto.setCalculationStartTime(reconciliationLetterCalculationTimeVo.getCalculationStartTime());
            reconciliationLetterCreateDto.setCalculationEndTime(reconciliationLetterCalculationTimeVo.getCalculationEndTime());
            return reconciliationLetterCreateDto;
          }).collect(Collectors.toList());
      //8.生成对应客户的对账函
      if (CollectionUtils.isEmpty(letterCreateDtos)) {
        return;
      }
      createBatch(letterCreateDtos);
    }
  }

  @Override
  @Transactional
  public void handleCustomerQuestion(ReconciliationLetterContactRecordDto contactRecordDto) {
    questionOrAnswer(contactRecordDto, ReconciliationLetterOperateType.QUESTION);
  }

  @Override
  @Transactional
  public void handleManufacturerAnswer(ReconciliationLetterContactRecordDto contactRecordDto) {
    questionOrAnswer(contactRecordDto, ReconciliationLetterOperateType.ANSWER);
  }

  /**
   * 处理疑问和答复
   *
   * @param contactRecordDto
   * @param type
   */
  private void questionOrAnswer(ReconciliationLetterContactRecordDto contactRecordDto, ReconciliationLetterOperateType type) {
    Validate.notNull(contactRecordDto, "对账函沟通内容不能为空");
    Validate.notBlank(contactRecordDto.getContent(), "沟通内容不能为空");
    ReconciliationLetter reconciliationLetter =
        reconciliationLetterRepository.findByCode(
            contactRecordDto.getReconciliationLetterCode(), TenantUtils.getTenantCode());
    Validate.notNull(reconciliationLetter, "找不到对应的对账函信息");
    //主表更新
    if (ReconciliationLetterOperateType.ANSWER.equals(type)) {
      reconciliationLetter.setReconciliationLetterStatus(ReconciliationLetterStatus.WAIT_CUSTOMER_CONFIRMATION);
    } else {
      reconciliationLetter.setReconciliationLetterStatus(ReconciliationLetterStatus.WAIT_FINANCIAL_REVIEW);
    }
    reconciliationLetterRepository.updateById(reconciliationLetter);
    //创建沟通记录
    this.saveReconciliationLetterContactRecord(contactRecordDto,type);
  }

  @Override
  @Transactional
  public void handlePushCustomer(List<String> ids) {
    Validate.notEmpty(ids, "进行对账函业务操作时，业务唯一主键信息必须传入");
    List<ReconciliationLetter> reconciliationLetters =
        reconciliationLetterRepository.listByIds(ids);
    //验证
    Validate.isTrue(reconciliationLetters.stream().allMatch(reconciliationLetter ->
            (ReconciliationLetterStatus.WAIT_PUSH.equals(reconciliationLetter.getReconciliationLetterStatus()) ||
                ReconciliationLetterStatus.WAIT_FINANCIAL_REVIEW.equals(reconciliationLetter.getReconciliationLetterStatus())) &&
                DelFlagStatusEnum.NORMAL.getCode().equals(reconciliationLetter.getDelFlag()) &&
                EnableStatusEnum.ENABLE.getCode().equals(reconciliationLetter.getEnableStatus())),
        "只有启用状态且未被删除的对账函，状态为待推送、待财务复核时才能被推送！");
    //更改状态
    for (ReconciliationLetter reconciliationLetter : reconciliationLetters) {
      reconciliationLetter.setReconciliationLetterStatus(ReconciliationLetterStatus.WAIT_CUSTOMER_CONFIRMATION);
    }
    reconciliationLetterRepository.updateBatchById(reconciliationLetters);
    //记录更新记录
    for (ReconciliationLetter reconciliationLetter : reconciliationLetters) {
      this.saveUpdateRecord(reconciliationLetter,ReconciliationLetterOperateType.PUSH);
    }
  }

  @Override
  @Transactional
  public void updateByIds(List<String> ids) {
    Validate.notEmpty(ids, "进行对账函业务操作时，业务唯一主键信息必须传入");
    List<ReconciliationLetter> reconciliationLetters =
        reconciliationLetterRepository.listByIds(ids);
    //验证
    Validate.isTrue(reconciliationLetters.stream().allMatch(reconciliationLetter ->
            (ReconciliationLetterStatus.WAIT_PUSH.equals(reconciliationLetter.getReconciliationLetterStatus()) ||
                ReconciliationLetterStatus.WAIT_FINANCIAL_REVIEW.equals(reconciliationLetter.getReconciliationLetterStatus())) &&
                DelFlagStatusEnum.NORMAL.getCode().equals(reconciliationLetter.getDelFlag()) &&
                EnableStatusEnum.ENABLE.getCode().equals(reconciliationLetter.getEnableStatus())),
        "只有启用状态且未被删除的对账函，状态为待推送、待财务复核时才能被更新！");
    //更新
    for (ReconciliationLetter reconciliationLetter : reconciliationLetters) {
      //查询对账规则
      ReconciliationTemplateVo reconciliationTemplateVo =
          templateVoService.findDetailsByCode(reconciliationLetter.getReconciliationTemplateCode());
      Validate.notNull(reconciliationTemplateVo, "找不到对应对账规则");
      Validate.isTrue(EnableStatusEnum.ENABLE.getCode().equals(reconciliationTemplateVo.getEnableStatus()),
          "对账规则已被禁用，无法生成对应的对账函！");
      //获取对账要素
      List<ReconciliationTemplateElementVo> elements = reconciliationTemplateVo.getElements();
      Validate.notEmpty(elements, "无法获取到对账规则对应的对账要素数据");
      //更新要素内容
      for (ReconciliationTemplateElementVo element : elements) {
        ReconciliationElementRegister<?> elementRegister = elementContext.getElementRegisterByCode(element.getElementCode());
        Validate.notNull(elementRegister, "找不到对应的对账要素注册器");
        elementRegister.update(reconciliationLetter.getReconciliationLetterCode(), reconciliationLetter.getCustomerCode(), reconciliationLetter.getCalculationStartTime(), reconciliationLetter.getCalculationEndTime());
      }
      reconciliationLetterRepository.updateById(reconciliationLetter);
      //记录更新记录
      saveUpdateRecord(reconciliationLetter,ReconciliationLetterOperateType.UPDATE);
    }
  }

  @Override
  @Transactional
  public void handleCustomerConfirm(List<String> ids) {
    Validate.notEmpty(ids, "进行对账函业务操作时，业务唯一主键信息必须传入");
    List<ReconciliationLetter> reconciliationLetters =
        reconciliationLetterRepository.listByIds(ids);
    //验证
    Validate.isTrue(reconciliationLetters.stream().allMatch(reconciliationLetter ->
            ReconciliationLetterStatus.WAIT_CUSTOMER_CONFIRMATION.equals(reconciliationLetter.getReconciliationLetterStatus()) &&
                DelFlagStatusEnum.NORMAL.getCode().equals(reconciliationLetter.getDelFlag()) &&
                EnableStatusEnum.ENABLE.getCode().equals(reconciliationLetter.getEnableStatus())),
        "只有启用状态且未被删除的对账函，状态为待客户确认时才能被确认！");
    //更改状态
    Date date = new Date();
    for (ReconciliationLetter reconciliationLetter : reconciliationLetters) {
      reconciliationLetter.setReconciliationLetterStatus(ReconciliationLetterStatus.COMPLETED);
      reconciliationLetter.setConfirmTime(date);
    }
    reconciliationLetterRepository.updateBatchById(reconciliationLetters);
    //记录更新记录
    for (ReconciliationLetter reconciliationLetter : reconciliationLetters) {
      this.saveUpdateRecord(reconciliationLetter,ReconciliationLetterOperateType.CONFIRM);
    }
  }

  @Override
  @Transactional
  public void deleteBatch(List<String> ids) {
    Validate.notEmpty(ids, "进行对账函业务操作时，业务唯一主键信息必须传入");
    reconciliationLetterRepository.deleteBatch(ids);
  }

  @Override
  public List<ReconciliationLetterVo> findByTemplateCodes(List<String> templateCodes) {
    if(CollectionUtils.isEmpty(templateCodes)){
      return null;
    }
    return reconciliationLetterRepository.findByTemplateCodes(templateCodes,TenantUtils.getTenantCode());
  }

  private void validateCreate(ReconciliationLetterCreateDto reconciliationLetterCreateDto) {
    Validate.notNull(reconciliationLetterCreateDto, "对账函创建内容不能为空");
    Validate.notBlank(reconciliationLetterCreateDto.getCustomerCode(), "客户编码不能为空");
    Validate.notBlank(reconciliationLetterCreateDto.getCustomerName(), "客户名称不能为空");
    Validate.notBlank(reconciliationLetterCreateDto.getReconciliationTemplateCode(), "对账规则编码不能为空");
    Validate.notBlank(reconciliationLetterCreateDto.getReconciliationTemplateName(), "对账规则名称不能为空");
    Validate.notNull(reconciliationLetterCreateDto.getCalculationStartTime(), "对账计算开始时间不能为空");
    Validate.notNull(reconciliationLetterCreateDto.getCalculationEndTime(), "对账计算开始时间不能为空");
    List<String> elementCodes = reconciliationLetterCreateDto.getElementCodes();
    Validate.notEmpty(elementCodes, "创建对账函时，对账要素不能为空");
  }

  /**
   * 客户-对账函分页查询
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<ReconciliationLetterVo> findByReconciliationLetterPaginationDto(Pageable pageable, ReconciliationLetterPaginationDto dto) {
    LoginUserDetailsForEMS loginUserDetails = this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
    Page<ReconciliationLetterVo> pageResultEmpty = new Page<>(0L, 0L, 0L);
    if (StringUtils.isBlank(loginUserDetails.getCustomerCode())) {
      return pageResultEmpty;
    }
    dto.setCustomerCode(loginUserDetails.getCustomerCode());
    //对账月份不为空处理时间
    Date reconciliationLetterMonth = dto.getReconciliationLetterMonth();
    if(!org.springframework.util.ObjectUtils.isEmpty(reconciliationLetterMonth)){
      dto.setStartTime(getFirstDayOfMonth(reconciliationLetterMonth));
      dto.setEndTime(getLastDayOfMonth(reconciliationLetterMonth));
    }
    //查询状态为待客户确认和已完成
    List<ReconciliationLetterStatus> statusList = Lists.newArrayList();
    statusList.add(ReconciliationLetterStatus.WAIT_CUSTOMER_CONFIRMATION);
    statusList.add(ReconciliationLetterStatus.COMPLETED);
    statusList.add(ReconciliationLetterStatus.WAIT_FINANCIAL_REVIEW);
    dto.setReconciliationLetterStatusList(statusList);
    return this.findByConditions(pageable,dto);
  }

  /**
   * 客户-待客户确认对账函数量
   * @param dto
   * @return
   */
  @Override
  public Integer findWaitConfirmationCountByCurrentCustomer(ReconciliationLetterPaginationDto dto) {
    LoginUserDetailsForEMS loginUserDetails = this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
    if (StringUtils.isBlank(loginUserDetails.getCustomerCode())) {
      return 0;
    }
    dto.setCustomerCode(loginUserDetails.getCustomerCode());
    //查询状态为待客户确认和已完成
    List<ReconciliationLetterStatus> statusList = Lists.newArrayList();
    statusList.add(ReconciliationLetterStatus.WAIT_CUSTOMER_CONFIRMATION);
    dto.setReconciliationLetterStatusList(statusList);
    return this.reconciliationLetterRepository.findWaitConfirmationCountByCurrentCustomer(dto);
  }

  /**
   * 获取指定年月的第一天 01 00:00:00
   * @param reconciliationLetterMonth
   * @return
   */
  private Date getFirstDayOfMonth(Date reconciliationLetterMonth) {
    Calendar cal = Calendar.getInstance();
    cal.setTime(reconciliationLetterMonth);
    //获取月最小天数
    int firstDay = cal.getMinimum(Calendar.DATE);
    //设置日历中月份的最小天数
    cal.set(Calendar.DAY_OF_MONTH,firstDay);
    cal.set(Calendar.HOUR_OF_DAY,0);
    cal.set(Calendar.MINUTE,0);
    cal.set(Calendar.SECOND,0);
    cal.set(Calendar.MILLISECOND,0);
    return cal.getTime();
  }

  /**
   * 获取指定年月的最后一天
   * @param reconciliationLetterMonth
   * @return
   */
  private Date getLastDayOfMonth(Date reconciliationLetterMonth) {
    Calendar cal = Calendar.getInstance();
    cal.setTime(reconciliationLetterMonth);
    //获取月最大天数
    int lastDay = cal.getActualMaximum(Calendar.DATE);
    //设置日历中月份的最大天数
    cal.set(Calendar.DAY_OF_MONTH,lastDay);
    cal.set(Calendar.HOUR_OF_DAY,23);
    cal.set(Calendar.MINUTE,59);
    cal.set(Calendar.SECOND,59);
    cal.set(Calendar.MILLISECOND,999);
    return cal.getTime();
  }


  private void saveReconciliationLetterContactRecord(ReconciliationLetterContactRecordDto contactRecordDto,ReconciliationLetterOperateType reconciliationLetterOperateType){
    //创建沟通记录
    JSONObject loginUserJson = loginUserService.getLoginUserJson();
    ReconciliationContactRecord reconciliationContactRecord = new ReconciliationContactRecord();
    reconciliationContactRecord.setTenantCode(TenantUtils.getTenantCode());
    reconciliationContactRecord.setReconciliationLetterCode(contactRecordDto.getReconciliationLetterCode());
    reconciliationContactRecord.setPostCode(loginUserJson.getString(LoginUserConstant.FIELD_POST_CODE));
    reconciliationContactRecord.setPostName(loginUserJson.getString(LoginUserConstant.FIELD_POST_NAME));
    reconciliationContactRecord.setOrgCode(loginUserJson.getString(LoginUserConstant.FIELD_ORG_CODE));
    reconciliationContactRecord.setOrgName(loginUserJson.getString(LoginUserConstant.FIELD_ORG_NAME));
    reconciliationContactRecord.setReconciliationLetterOperateType(reconciliationLetterOperateType);
    reconciliationContactRecord.setContent(contactRecordDto.getContent());
    contactRecordRepository.save(reconciliationContactRecord);
    //保存附件
    List<ReconciliationLetterContactRecordFileDto> fileDtos = contactRecordDto.getFiles();
    if (CollectionUtils.isEmpty(fileDtos)) {
      return;
    }
    List<ReconciliationContactRecordFile> reconciliationContactRecordFiles =
        (List<ReconciliationContactRecordFile>) nebulaToolkitService.copyCollectionByWhiteList(
            fileDtos,
            ReconciliationLetterContactRecordFileDto.class,
            ReconciliationContactRecordFile.class,
            HashSet.class,
            ArrayList.class);
    for (ReconciliationContactRecordFile reconciliationContactRecordFile : reconciliationContactRecordFiles) {
      reconciliationContactRecordFile.setTenantCode(TenantUtils.getTenantCode());
      reconciliationContactRecordFile.setReconciliationContactRecordId(reconciliationContactRecord.getId());
    }
    contactRecordFileRepository.saveBatch(reconciliationContactRecordFiles);
  }
}
