package com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate;

import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterCalculationTimeCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterCalculationTimeUpdateDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationLetterCalculationTimeVo;

import java.util.List;

/**
 * Created by Bao Hongbin on 2021-12-20 15:03.
 */
public interface ReconciliationLetterCalculationTimeVoService {

  /**
   * 通过对账规则编码查询计算时间
   *
   * @param reconciliationTemplateCode
   * @return
   */
  List<ReconciliationLetterCalculationTimeVo> findListByTemplateCode(String reconciliationTemplateCode);

  /**
   * 保存计算时间
   *
   * @param reconciliationTemplateCode
   * @param calculationTimes
   * @return
   */
  List<ReconciliationLetterCalculationTimeVo> create(String reconciliationTemplateCode, List<ReconciliationLetterCalculationTimeCreateDto> calculationTimes);

  /**
   * 更新计算时间
   *
   * @param reconciliationTemplateCode
   * @param calculationTimes
   * @return
   */
  List<ReconciliationLetterCalculationTimeVo> update(String reconciliationTemplateCode, List<ReconciliationLetterCalculationTimeUpdateDto> calculationTimes);

  /**
   * 根据对账规则无效化计算定时任务
   *
   * @param templateCodes
   */
  void invalidBatchByTemplateCodes(List<String> templateCodes);

  /**
   * 根据对账规则有效化计算定时任务
   *
   * @param templateCodes
   */
  void effectiveBatchByTemplateCodes(List<String> templateCodes);

  /**
   * 根据对账规则删除计算定时任务
   *
   * @param templateCodes
   */
  void deleteBatchByTemplateCodes(List<String> templateCodes);
}
