package com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate;

import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterCalculationTimeCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterCalculationTimeUpdateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateElementCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateElementUpdateDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateElementVo;

import java.util.List;

/**
 * Created by Bao Hongbin on 2021-12-20 15:02.
 */
public interface ReconciliationTemplateElementVoService {
  /**
   * 通过对账规则编码查询对账要素
   *
   * @param reconciliationTemplateCode
   * @return
   */
  List<ReconciliationTemplateElementVo> findListByTemplateCode(String reconciliationTemplateCode);


  /**
   * 保存对账要素
   * @param reconciliationTemplateCode
   * @param elements
   * @return
   */
  List<ReconciliationTemplateElementVo> create(String reconciliationTemplateCode, List<ReconciliationTemplateElementCreateDto> elements);

  /**
   * 更新对账要素
   * @param reconciliationTemplateCode
   * @param elements
   * @return
   */
  List<ReconciliationTemplateElementVo> update(String reconciliationTemplateCode, List<ReconciliationTemplateElementUpdateDto> elements);

}
