package com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate;

import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterCalculationTimeCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterCalculationTimeUpdateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateRangeCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateRangeUpdateDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateRangeVo;

import java.util.List;

/**
 * Created by Bao Hongbin on 2021-12-20 15:02.
 */
public interface ReconciliationTemplateRangeVoService {
  /**
   * 通过对账规则编码查询生效范围
   *
   * @param reconciliationTemplateCode
   * @return
   */
  List<ReconciliationTemplateRangeVo> findListByTemplateCode(String reconciliationTemplateCode);


  /**
   * 保存生效范围
   * @param reconciliationTemplateCode
   * @param ranges
   * @return
   */
  List<ReconciliationTemplateRangeVo> create(String reconciliationTemplateCode, List<ReconciliationTemplateRangeCreateDto> ranges);

  /**
   * 更新对账要素
   * @param reconciliationTemplateCode
   * @param ranges
   * @return
   */
  List<ReconciliationTemplateRangeVo> update(String reconciliationTemplateCode, List<ReconciliationTemplateRangeUpdateDto> ranges);

}
