package com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.internal;
/**
 * Created by Bao Hongbin on 2021-12-20 16:58.
 */

import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate.ReconciliationTemplateRange;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationtemplate.ReconciliationTemplateRangeRepository;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateRangeVoService;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateRangeCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateRangeUpdateDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateRangeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @program: crm-dms
 * @description:
 * @author: Bao Hongbin
 * @create: 2021-12-20 16:58
 **/
@Slf4j
@Service
public class ReconciliationTemplateRangeVoServiceImpl implements ReconciliationTemplateRangeVoService {
  @Autowired(required = false)
  private ReconciliationTemplateRangeRepository reconciliationTemplateRangeRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<ReconciliationTemplateRangeVo> findListByTemplateCode(String reconciliationTemplateCode) {
    List<ReconciliationTemplateRange> ranges =
        reconciliationTemplateRangeRepository.findListByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
    return (List<ReconciliationTemplateRangeVo>) nebulaToolkitService.copyCollectionByWhiteList(ranges, ReconciliationTemplateRange.class
        , ReconciliationTemplateRangeVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public List<ReconciliationTemplateRangeVo> create(String reconciliationTemplateCode, List<ReconciliationTemplateRangeCreateDto> ranges) {
    //验证
    validateCreate(reconciliationTemplateCode, ranges);
    //保存
    List<ReconciliationTemplateRange> reconciliationTemplateRanges =
        (List<ReconciliationTemplateRange>) nebulaToolkitService.copyCollectionByWhiteList(ranges, ReconciliationTemplateRangeCreateDto.class
            , ReconciliationTemplateRange.class, HashSet.class, ArrayList.class);
    return save(reconciliationTemplateCode, reconciliationTemplateRanges);
  }

  /**
   * 保存
   *
   * @param reconciliationTemplateCode
   * @param reconciliationTemplateRanges
   * @return
   */
  private List<ReconciliationTemplateRangeVo> save(String reconciliationTemplateCode, List<ReconciliationTemplateRange> reconciliationTemplateRanges) {
    reconciliationTemplateRanges.forEach(reconciliationTemplateElement -> {
      reconciliationTemplateElement.setTenantCode(TenantUtils.getTenantCode());
      reconciliationTemplateElement.setReconciliationTemplateCode(reconciliationTemplateCode);
    });
    reconciliationTemplateRangeRepository.saveBatch(reconciliationTemplateRanges);
    //封装返回
    return (List<ReconciliationTemplateRangeVo>) nebulaToolkitService.copyCollectionByWhiteList(
        reconciliationTemplateRanges,
        ReconciliationTemplateRange.class,
        ReconciliationTemplateRangeVo.class,
        HashSet.class, ArrayList.class);
  }

  private void validateCreate(String reconciliationTemplateCode, List<ReconciliationTemplateRangeCreateDto> ranges) {
    Validate.notBlank(reconciliationTemplateCode, "对账规则编码不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(ranges), "新增对账规则生效范围数据不能为空");
    for (ReconciliationTemplateRangeCreateDto rangeCreateDto : ranges) {
      Validate.notBlank(rangeCreateDto.getDataCode(), "生效范围数据编码不能为空");
      Validate.notBlank(rangeCreateDto.getDataName(), "生效范围数据名称不能为空");
      Validate.notNull(rangeCreateDto.getRangeType(), "生效范围数据类型不能为空");
    }
  }

  @Override
  @Transactional
  public List<ReconciliationTemplateRangeVo> update(String reconciliationTemplateCode, List<ReconciliationTemplateRangeUpdateDto> ranges) {
    //验证
    validateUpdate(reconciliationTemplateCode, ranges);
    //删除
    reconciliationTemplateRangeRepository.deleteByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
    //保存
    List<ReconciliationTemplateRange> reconciliationTemplateRanges =
        (List<ReconciliationTemplateRange>) nebulaToolkitService.copyCollectionByWhiteList(ranges, ReconciliationTemplateRangeUpdateDto.class
            , ReconciliationTemplateRange.class, HashSet.class, ArrayList.class);
    return save(reconciliationTemplateCode, reconciliationTemplateRanges);
  }

  private void validateUpdate(String reconciliationTemplateCode, List<ReconciliationTemplateRangeUpdateDto> rangeUpdateDtos) {
    Validate.notBlank(reconciliationTemplateCode, "对账规则编码不能为空");
    List<ReconciliationTemplateRange> ranges =
        reconciliationTemplateRangeRepository.findListByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
    Validate.notEmpty(ranges, "无法找到对账规则对应的生效范围数据");
    Validate.isTrue(CollectionUtils.isNotEmpty(ranges), "新增对账规则生效范围数据不能为空");
    for (ReconciliationTemplateRangeUpdateDto rangeUpdateDto : rangeUpdateDtos) {
      Validate.notBlank(rangeUpdateDto.getDataCode(), "生效范围数据编码不能为空");
      Validate.notBlank(rangeUpdateDto.getDataName(), "生效范围数据名称不能为空");
      Validate.notNull(rangeUpdateDto.getRangeType(), "生效范围数据类型不能为空");
    }
  }
}
