/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.reconciliation.local.context.reconciliationtemplate;

import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationtemplate.ReconciliationTemplateRangeRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.ReconciliationTemplateRangeInfo.ReconciliationTemplateRangeInfoVo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReconciliationTemplateRangeContext {
    private static final Map<String, ReconciliationTemplateRangeInfoVo> RANGE_INFO_CACHE = new ConcurrentHashMap<String, ReconciliationTemplateRangeInfoVo>();
    private static final Map<String, ReconciliationTemplateRangeRegister> RANGE_REGISTERS_CACHE = new ConcurrentHashMap<String, ReconciliationTemplateRangeRegister>();

    @Autowired(required=false)
    public ReconciliationTemplateRangeContext(List<ReconciliationTemplateRangeRegister> rangeRegisters) {
        if (CollectionUtils.isNotEmpty(rangeRegisters)) {
            for (ReconciliationTemplateRangeRegister rangeRegister : rangeRegisters) {
                ReconciliationTemplateRangeInfoVo reconciliationRangeInfo = rangeRegister.getReconciliationRangeInfo();
                Validate.notNull((Object)reconciliationRangeInfo, (String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u8d26\u89c4\u5219\u751f\u6548\u8303\u56f4\u7684\u57fa\u672c\u4fe1\u606f", (Object[])new Object[0]);
                RANGE_INFO_CACHE.put(reconciliationRangeInfo.getRangeType(), reconciliationRangeInfo);
                RANGE_REGISTERS_CACHE.put(reconciliationRangeInfo.getRangeType(), rangeRegister);
            }
        }
    }

    public List<ReconciliationTemplateRangeInfoVo> getAllRangeInfo() {
        if (CollectionUtils.isEmpty(RANGE_INFO_CACHE.values())) {
            return (List)RANGE_INFO_CACHE.values();
        }
        ArrayList<ReconciliationTemplateRangeInfoVo> reconciliationTemplateRangeInfoVos = new ArrayList<ReconciliationTemplateRangeInfoVo>(RANGE_INFO_CACHE.values());
        reconciliationTemplateRangeInfoVos.sort(Comparator.comparing(ReconciliationTemplateRangeInfoVo::getRangeSort));
        return reconciliationTemplateRangeInfoVos;
    }

    public ReconciliationTemplateRangeRegister getRangeRegisterByCode(String rangeType) {
        if (StringUtils.isBlank((CharSequence)rangeType)) {
            return null;
        }
        if (CollectionUtils.isEmpty(RANGE_REGISTERS_CACHE.values())) {
            return null;
        }
        return RANGE_REGISTERS_CACHE.get(rangeType);
    }
}

