/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.reconciliation.local.register.reconciliationelement.internal;

import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement.SignatureColumn;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationelement.SignatureColumnRepository;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationelement.ReconciliationElementRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata.SignatureColumnDataVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementinfo.ReconciliationElementInfoVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="signatureColumnDataVoRegister")
public class SignatureColumnDataVoRegisterImpl
implements ReconciliationElementRegister<SignatureColumnDataVo> {
    private static final String ELEMENT_CODE = "signature_column";
    private static final String ELEMENT_NAME = "\u7b7e\u7f72\u680f";
    private static final Integer ELEMENT_SORT = 3;
    private static final String ELEMENT_REMARKS = "\u7b7e\u7f72\u680f";
    @Value(value="reconciliation.defaultManufacturerName")
    private String defaultManufacturerName = "\u9ed8\u8ba4\u5382\u5546\u516c\u53f8\u540d\u79f0";
    @Autowired(required=false)
    private SignatureColumnRepository repository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public ReconciliationElementInfoVo getReconciliationElementInfo() {
        return new ReconciliationElementInfoVo(ELEMENT_CODE, "\u7b7e\u7f72\u680f", ELEMENT_SORT, "\u7b7e\u7f72\u680f");
    }

    public SignatureColumnDataVo getByLetterCode(String letterCode, String customerCode) {
        if (StringUtils.isBlank((CharSequence)letterCode)) {
            return null;
        }
        SignatureColumn signatureColumn = this.repository.findByLetterCodeAndCustomerCode(customerCode, letterCode, TenantUtils.getTenantCode());
        return (SignatureColumnDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)signatureColumn, SignatureColumnDataVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public SignatureColumnDataVo create(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime) {
        SignatureColumn signatureColumn = new SignatureColumn();
        signatureColumn.setTenantCode(TenantUtils.getTenantCode());
        signatureColumn.setElementCode(ELEMENT_CODE);
        signatureColumn.setLetterCode(letterCode);
        signatureColumn.setCustomerCode(customerCode);
        signatureColumn.setCalculationStartTime(calculationStartTime);
        signatureColumn.setCalculationEndTime(calculationEndTime);
        signatureColumn.setManufacturerCode(TenantUtils.getAppCode());
        signatureColumn.setManufacturerName(this.defaultManufacturerName);
        this.repository.save((Object)signatureColumn);
        return (SignatureColumnDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)signatureColumn, SignatureColumnDataVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public SignatureColumnDataVo update(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime) {
        SignatureColumn signatureColumn = this.repository.findByLetterCodeAndCustomerCode(customerCode, letterCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)signatureColumn), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5bf9\u8d26\u8981\u7d20", (Object[])new Object[0]);
        signatureColumn.setManufacturerCode(TenantUtils.getAppCode());
        signatureColumn.setManufacturerName(this.defaultManufacturerName);
        this.repository.updateById((Object)signatureColumn);
        return (SignatureColumnDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)signatureColumn, SignatureColumnDataVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

