/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.reconciliation.local.service.reconciliationletter.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.dms.business.reconciliation.local.context.reconciliationelement.ReconciliationElementContext;
import com.biz.crm.dms.business.reconciliation.local.context.reconciliationtemplate.ReconciliationTemplateRangeContext;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationletter.ReconciliationContactRecord;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationletter.ReconciliationContactRecordFile;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationletter.ReconciliationLetter;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationletter.ReconciliationContactRecordFileRepository;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationletter.ReconciliationContactRecordRepository;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationletter.ReconciliationLetterRepository;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationletter.ReconciliationLetterVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateVoService;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterContactRecordDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterContactRecordFileDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterManualCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterPaginationDto;
import com.biz.crm.dms.business.reconciliation.sdk.enums.ReconciliationLetterOperateType;
import com.biz.crm.dms.business.reconciliation.sdk.enums.ReconciliationLetterStatus;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationelement.ReconciliationElementRegister;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationtemplate.ReconciliationTemplateRangeRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationletter.ReconciliationLetterVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationLetterCalculationTimeVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateElementVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateRangeVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ReconciliationLetterVoServiceImpl
implements ReconciliationLetterVoService {
    @Autowired(required=false)
    private ReconciliationLetterRepository reconciliationLetterRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ReconciliationElementContext elementContext;
    @Autowired(required=false)
    private GenerateCodeService generateCode;
    @Autowired(required=false)
    private ReconciliationTemplateVoService templateVoService;
    @Autowired(required=false)
    private ReconciliationTemplateRangeContext rangeContext;
    @Autowired(required=false)
    private ReconciliationContactRecordRepository contactRecordRepository;
    @Autowired(required=false)
    private ReconciliationContactRecordFileRepository contactRecordFileRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public Page<ReconciliationLetterVo> findByConditions(Pageable pageable, ReconciliationLetterPaginationDto reconciliationLetterPaginationDto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        ReconciliationLetterPaginationDto dto = Optional.ofNullable(reconciliationLetterPaginationDto).orElse(new ReconciliationLetterPaginationDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.reconciliationLetterRepository.findByConditions(pageable, dto);
    }

    @Override
    public ReconciliationLetterVo findDetailsById(String id) {
        if (!StringUtils.isNotEmpty((CharSequence)id)) {
            return null;
        }
        ReconciliationLetterVo reconciliationLetterVo = this.reconciliationLetterRepository.findDetailsById(id, TenantUtils.getTenantCode());
        ReconciliationTemplateVo reconciliationTemplateVo = this.templateVoService.findDetailsByCode(reconciliationLetterVo.getReconciliationTemplateCode());
        Validate.notNull((Object)reconciliationTemplateVo, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u8d26\u51fd\u5bf9\u5e94\u5bf9\u8d26\u89c4\u5219\u4fe1\u606f", (Object[])new Object[0]);
        List elementCodes = reconciliationTemplateVo.getElements().stream().map(ReconciliationTemplateElementVo::getElementCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(elementCodes)) {
            List elementDataVos = elementCodes.stream().map(elementCode -> {
                ReconciliationElementRegister elementRegister = this.elementContext.getElementRegisterByCode((String)elementCode);
                Validate.notNull((Object)elementRegister, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u8d26\u8981\u7d20\u6ce8\u518c\u5668", (Object[])new Object[0]);
                return elementRegister.getByLetterCode(reconciliationLetterVo.getReconciliationLetterCode(), reconciliationLetterVo.getCustomerCode());
            }).collect(Collectors.toList());
            reconciliationLetterVo.setElementDataVos(elementDataVos);
        }
        return reconciliationLetterVo;
    }

    @Override
    @Transactional
    public void create(ReconciliationLetterCreateDto reconciliationLetterCreateDto) {
        this.validateCreate(reconciliationLetterCreateDto);
        ReconciliationLetter reconciliationLetter = this.reconciliationLetterRepository.findExist(reconciliationLetterCreateDto.getCustomerCode(), reconciliationLetterCreateDto.getReconciliationTemplateCode(), reconciliationLetterCreateDto.getCalculationStartTime(), reconciliationLetterCreateDto.getCalculationEndTime(), TenantUtils.getTenantCode());
        if (Objects.isNull((Object)reconciliationLetter)) {
            reconciliationLetter = (ReconciliationLetter)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationLetterCreateDto, ReconciliationLetter.class, HashSet.class, ArrayList.class, new String[0]));
            reconciliationLetter.setReconciliationLetterStatus(ReconciliationLetterStatus.WAIT_PUSH);
            reconciliationLetter.setTenantCode(TenantUtils.getTenantCode());
            reconciliationLetter.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            reconciliationLetter.setEnableStatus(null != reconciliationLetter.getEnableStatus() ? reconciliationLetter.getEnableStatus() : EnableStatusEnum.ENABLE.getCode());
            String reconciliationLetterCode = (String)this.generateCode.generateCode("DZH" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMM"), 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
            ReconciliationLetter repository = this.reconciliationLetterRepository.findByCode(reconciliationLetterCode, TenantUtils.getTenantCode());
            Validate.isTrue((boolean)Objects.isNull((Object)repository), (String)"\u5bf9\u8d26\u7f16\u7801\u5df2\u5b58\u5728\uff01", (Object[])new Object[0]);
            reconciliationLetter.setReconciliationLetterCode(reconciliationLetterCode);
            this.reconciliationLetterRepository.save((Object)reconciliationLetter);
            List elementCodes = reconciliationLetterCreateDto.getElementCodes();
            for (String elementCode : elementCodes) {
                ReconciliationElementRegister elementRegister = this.elementContext.getElementRegisterByCode(elementCode);
                Validate.notNull((Object)elementRegister, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5bf9\u8d26\u8981\u7d20\u6ce8\u518c\u5668", (Object[])new Object[0]);
                elementRegister.create(reconciliationLetter.getReconciliationLetterCode(), reconciliationLetter.getCustomerCode(), reconciliationLetter.getCalculationStartTime(), reconciliationLetter.getCalculationEndTime());
            }
        } else if (ReconciliationLetterStatus.WAIT_PUSH.equals((Object)reconciliationLetter.getReconciliationLetterStatus()) || ReconciliationLetterStatus.WAIT_FINANCIAL_REVIEW.equals((Object)reconciliationLetter.getReconciliationLetterStatus())) {
            List elementCodes = reconciliationLetterCreateDto.getElementCodes();
            for (String elementCode : elementCodes) {
                ReconciliationElementRegister elementRegister = this.elementContext.getElementRegisterByCode(elementCode);
                Validate.notNull((Object)elementRegister, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5bf9\u8d26\u8981\u7d20\u6ce8\u518c\u5668", (Object[])new Object[0]);
                elementRegister.update(reconciliationLetter.getReconciliationLetterCode(), reconciliationLetter.getCustomerCode(), reconciliationLetter.getCalculationStartTime(), reconciliationLetter.getCalculationEndTime());
            }
            this.reconciliationLetterRepository.updateById((Object)reconciliationLetter);
            this.saveUpdateRecord(reconciliationLetter, ReconciliationLetterOperateType.UPDATE);
        }
    }

    private void saveUpdateRecord(ReconciliationLetter reconciliationLetter, ReconciliationLetterOperateType type) {
        JSONObject loginUserJson = this.loginUserService.getLoginUserJson();
        ReconciliationContactRecord reconciliationContactRecord = new ReconciliationContactRecord();
        reconciliationContactRecord.setTenantCode(TenantUtils.getTenantCode());
        reconciliationContactRecord.setReconciliationLetterCode(reconciliationLetter.getReconciliationLetterCode());
        reconciliationContactRecord.setPostCode(loginUserJson.getString("postCode"));
        reconciliationContactRecord.setPostName(loginUserJson.getString("postName"));
        reconciliationContactRecord.setOrgCode(loginUserJson.getString("orgCode"));
        reconciliationContactRecord.setOrgName(loginUserJson.getString("orgName"));
        reconciliationContactRecord.setReconciliationLetterOperateType(type);
        this.contactRecordRepository.save((Object)reconciliationContactRecord);
    }

    @Override
    @Transactional
    public void createBatch(List<ReconciliationLetterCreateDto> reconciliationLetterCreateDtos) {
        Validate.notEmpty(reconciliationLetterCreateDtos, (String)"\u6279\u91cf\u521b\u5efa\u5bf9\u8d26\u51fd\u65f6\uff0c\u521b\u5efa\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        reconciliationLetterCreateDtos.forEach(this::create);
    }

    @Override
    @Transactional
    public void handleManualGenerate(ReconciliationLetterManualCreateDto reconciliationLetterManualCreateDto) {
        Validate.notNull((Object)reconciliationLetterManualCreateDto, (String)"\u5bf9\u8d26\u51fd\u521b\u5efa\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)reconciliationLetterManualCreateDto.getReconciliationTemplateCode(), (String)"\u5bf9\u8d26\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)reconciliationLetterManualCreateDto.getCalculationTimeId(), (String)"\u9009\u62e9\u7684\u5bf9\u8d26\u89c4\u5219\u8ba1\u7b97\u65f6\u95f4id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ReconciliationTemplateVo reconciliationTemplateVo = this.templateVoService.findDetailsByCode(reconciliationLetterManualCreateDto.getReconciliationTemplateCode());
        Validate.notNull((Object)reconciliationTemplateVo, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u5bf9\u8d26\u89c4\u5219", (Object[])new Object[0]);
        Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(reconciliationTemplateVo.getEnableStatus()), (String)"\u5bf9\u8d26\u89c4\u5219\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u751f\u6210\u5bf9\u5e94\u7684\u5bf9\u8d26\u51fd\uff01", (Object[])new Object[0]);
        List elements = reconciliationTemplateVo.getElements();
        Validate.notEmpty((Collection)elements, (String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u8d26\u89c4\u5219\u5bf9\u5e94\u7684\u5bf9\u8d26\u8981\u7d20\u6570\u636e", (Object[])new Object[0]);
        List calculationTimes = reconciliationTemplateVo.getCalculationTimes();
        Validate.notEmpty((Collection)calculationTimes, (String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u8d26\u89c4\u5219\u5bf9\u5e94\u7684\u5bf9\u8d26\u8ba1\u7b97\u65f6\u95f4\u6570\u636e", (Object[])new Object[0]);
        Map letterCalculationTimeVoMap = calculationTimes.stream().collect(Collectors.toMap(UuidVo::getId, Function.identity()));
        ReconciliationLetterCalculationTimeVo reconciliationLetterCalculationTimeVo = (ReconciliationLetterCalculationTimeVo)letterCalculationTimeVoMap.get(reconciliationLetterManualCreateDto.getCalculationTimeId());
        Validate.notNull((Object)reconciliationLetterCalculationTimeVo, (String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u6307\u5b9a\u7684\u5bf9\u8d26\u8ba1\u7b97\u65f6\u95f4\u6570\u636e", (Object[])new Object[0]);
        List ranges = reconciliationTemplateVo.getRanges();
        Validate.notEmpty((Collection)ranges, (String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u8d26\u89c4\u5219\u5bf9\u5e94\u7684\u751f\u6548\u8303\u56f4\u6570\u636e", (Object[])new Object[0]);
        Map<String, List<ReconciliationTemplateRangeVo>> rangeDataMap = ranges.stream().collect(Collectors.groupingBy(ReconciliationTemplateRangeVo::getRangeType));
        ArrayList infoVoList = new ArrayList();
        rangeDataMap.forEach((key, value) -> {
            ReconciliationTemplateRangeRegister rangeRegister = this.rangeContext.getRangeRegisterByCode((String)key);
            Validate.notNull((Object)rangeRegister, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7c7b\u578b\u7684\u751f\u6548\u8303\u56f4\u6ce8\u518c\u5668", (Object[])new Object[0]);
            List collect = value.stream().map(ReconciliationTemplateRangeVo::getDataCode).collect(Collectors.toList());
            List customerInfoByDataCodes = rangeRegister.getCustomerInfoByDataCodes(collect);
            if (CollectionUtils.isNotEmpty((Collection)customerInfoByDataCodes)) {
                infoVoList.addAll(customerInfoByDataCodes);
            }
        });
        if (CollectionUtils.isNotEmpty(infoVoList)) {
            List<ReconciliationLetterCreateDto> letterCreateDtos = infoVoList.stream().distinct().map(customerInfoVo -> {
                ReconciliationLetterCreateDto reconciliationLetterCreateDto = new ReconciliationLetterCreateDto();
                reconciliationLetterCreateDto.setCustomerCode(customerInfoVo.getCustomerCode());
                reconciliationLetterCreateDto.setCustomerName(customerInfoVo.getCustomerName());
                reconciliationLetterCreateDto.setReconciliationTemplateCode(reconciliationTemplateVo.getReconciliationTemplateCode());
                reconciliationLetterCreateDto.setReconciliationTemplateName(reconciliationTemplateVo.getReconciliationTemplateName());
                reconciliationLetterCreateDto.setElementCodes(elements.stream().map(ReconciliationTemplateElementVo::getElementCode).collect(Collectors.toList()));
                reconciliationLetterCreateDto.setCalculationStartTime(reconciliationLetterCalculationTimeVo.getCalculationStartTime());
                reconciliationLetterCreateDto.setCalculationEndTime(reconciliationLetterCalculationTimeVo.getCalculationEndTime());
                return reconciliationLetterCreateDto;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(letterCreateDtos)) {
                return;
            }
            this.createBatch(letterCreateDtos);
        }
    }

    @Override
    @Transactional
    public void handleCustomerQuestion(ReconciliationLetterContactRecordDto contactRecordDto) {
        this.questionOrAnswer(contactRecordDto, ReconciliationLetterOperateType.QUESTION);
    }

    @Override
    @Transactional
    public void handleManufacturerAnswer(ReconciliationLetterContactRecordDto contactRecordDto) {
        this.questionOrAnswer(contactRecordDto, ReconciliationLetterOperateType.ANSWER);
    }

    private void questionOrAnswer(ReconciliationLetterContactRecordDto contactRecordDto, ReconciliationLetterOperateType type) {
        Validate.notNull((Object)contactRecordDto, (String)"\u5bf9\u8d26\u51fd\u6c9f\u901a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contactRecordDto.getContent(), (String)"\u6c9f\u901a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ReconciliationLetter reconciliationLetter = this.reconciliationLetterRepository.findByCode(contactRecordDto.getReconciliationLetterCode(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)reconciliationLetter), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5bf9\u8d26\u51fd\u4fe1\u606f", (Object[])new Object[0]);
        if (ReconciliationLetterOperateType.ANSWER.equals((Object)type)) {
            reconciliationLetter.setReconciliationLetterStatus(ReconciliationLetterStatus.WAIT_CUSTOMER_CONFIRMATION);
        } else {
            reconciliationLetter.setReconciliationLetterStatus(ReconciliationLetterStatus.WAIT_FINANCIAL_REVIEW);
        }
        this.reconciliationLetterRepository.updateById((Object)reconciliationLetter);
        this.saveReconciliationLetterContactRecord(contactRecordDto, type);
    }

    @Override
    @Transactional
    public void handlePushCustomer(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8fdb\u884c\u5bf9\u8d26\u51fd\u4e1a\u52a1\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u552f\u4e00\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        List reconciliationLetters = this.reconciliationLetterRepository.listByIds(ids);
        Validate.isTrue((boolean)reconciliationLetters.stream().allMatch(reconciliationLetter -> (ReconciliationLetterStatus.WAIT_PUSH.equals((Object)reconciliationLetter.getReconciliationLetterStatus()) || ReconciliationLetterStatus.WAIT_FINANCIAL_REVIEW.equals((Object)reconciliationLetter.getReconciliationLetterStatus())) && DelFlagStatusEnum.NORMAL.getCode().equals(reconciliationLetter.getDelFlag()) && EnableStatusEnum.ENABLE.getCode().equals(reconciliationLetter.getEnableStatus())), (String)"\u53ea\u6709\u542f\u7528\u72b6\u6001\u4e14\u672a\u88ab\u5220\u9664\u7684\u5bf9\u8d26\u51fd\uff0c\u72b6\u6001\u4e3a\u5f85\u63a8\u9001\u3001\u5f85\u8d22\u52a1\u590d\u6838\u65f6\u624d\u80fd\u88ab\u63a8\u9001\uff01", (Object[])new Object[0]);
        for (ReconciliationLetter reconciliationLetter2 : reconciliationLetters) {
            reconciliationLetter2.setReconciliationLetterStatus(ReconciliationLetterStatus.WAIT_CUSTOMER_CONFIRMATION);
        }
        this.reconciliationLetterRepository.updateBatchById(reconciliationLetters);
        for (ReconciliationLetter reconciliationLetter2 : reconciliationLetters) {
            this.saveUpdateRecord(reconciliationLetter2, ReconciliationLetterOperateType.PUSH);
        }
    }

    @Override
    @Transactional
    public void updateByIds(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8fdb\u884c\u5bf9\u8d26\u51fd\u4e1a\u52a1\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u552f\u4e00\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        List reconciliationLetters = this.reconciliationLetterRepository.listByIds(ids);
        Validate.isTrue((boolean)reconciliationLetters.stream().allMatch(reconciliationLetter -> (ReconciliationLetterStatus.WAIT_PUSH.equals((Object)reconciliationLetter.getReconciliationLetterStatus()) || ReconciliationLetterStatus.WAIT_FINANCIAL_REVIEW.equals((Object)reconciliationLetter.getReconciliationLetterStatus())) && DelFlagStatusEnum.NORMAL.getCode().equals(reconciliationLetter.getDelFlag()) && EnableStatusEnum.ENABLE.getCode().equals(reconciliationLetter.getEnableStatus())), (String)"\u53ea\u6709\u542f\u7528\u72b6\u6001\u4e14\u672a\u88ab\u5220\u9664\u7684\u5bf9\u8d26\u51fd\uff0c\u72b6\u6001\u4e3a\u5f85\u63a8\u9001\u3001\u5f85\u8d22\u52a1\u590d\u6838\u65f6\u624d\u80fd\u88ab\u66f4\u65b0\uff01", (Object[])new Object[0]);
        for (ReconciliationLetter reconciliationLetter2 : reconciliationLetters) {
            ReconciliationTemplateVo reconciliationTemplateVo = this.templateVoService.findDetailsByCode(reconciliationLetter2.getReconciliationTemplateCode());
            Validate.notNull((Object)reconciliationTemplateVo, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u5bf9\u8d26\u89c4\u5219", (Object[])new Object[0]);
            Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(reconciliationTemplateVo.getEnableStatus()), (String)"\u5bf9\u8d26\u89c4\u5219\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u751f\u6210\u5bf9\u5e94\u7684\u5bf9\u8d26\u51fd\uff01", (Object[])new Object[0]);
            List elements = reconciliationTemplateVo.getElements();
            Validate.notEmpty((Collection)elements, (String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u8d26\u89c4\u5219\u5bf9\u5e94\u7684\u5bf9\u8d26\u8981\u7d20\u6570\u636e", (Object[])new Object[0]);
            for (ReconciliationTemplateElementVo element : elements) {
                ReconciliationElementRegister elementRegister = this.elementContext.getElementRegisterByCode(element.getElementCode());
                Validate.notNull((Object)elementRegister, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5bf9\u8d26\u8981\u7d20\u6ce8\u518c\u5668", (Object[])new Object[0]);
                elementRegister.update(reconciliationLetter2.getReconciliationLetterCode(), reconciliationLetter2.getCustomerCode(), reconciliationLetter2.getCalculationStartTime(), reconciliationLetter2.getCalculationEndTime());
            }
            this.reconciliationLetterRepository.updateById((Object)reconciliationLetter2);
            this.saveUpdateRecord(reconciliationLetter2, ReconciliationLetterOperateType.UPDATE);
        }
    }

    @Override
    @Transactional
    public void handleCustomerConfirm(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8fdb\u884c\u5bf9\u8d26\u51fd\u4e1a\u52a1\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u552f\u4e00\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        List reconciliationLetters = this.reconciliationLetterRepository.listByIds(ids);
        Validate.isTrue((boolean)reconciliationLetters.stream().allMatch(reconciliationLetter -> ReconciliationLetterStatus.WAIT_CUSTOMER_CONFIRMATION.equals((Object)reconciliationLetter.getReconciliationLetterStatus()) && DelFlagStatusEnum.NORMAL.getCode().equals(reconciliationLetter.getDelFlag()) && EnableStatusEnum.ENABLE.getCode().equals(reconciliationLetter.getEnableStatus())), (String)"\u53ea\u6709\u542f\u7528\u72b6\u6001\u4e14\u672a\u88ab\u5220\u9664\u7684\u5bf9\u8d26\u51fd\uff0c\u72b6\u6001\u4e3a\u5f85\u5ba2\u6237\u786e\u8ba4\u65f6\u624d\u80fd\u88ab\u786e\u8ba4\uff01", (Object[])new Object[0]);
        Date date = new Date();
        for (ReconciliationLetter reconciliationLetter2 : reconciliationLetters) {
            reconciliationLetter2.setReconciliationLetterStatus(ReconciliationLetterStatus.COMPLETED);
            reconciliationLetter2.setConfirmTime(date);
        }
        this.reconciliationLetterRepository.updateBatchById(reconciliationLetters);
        for (ReconciliationLetter reconciliationLetter2 : reconciliationLetters) {
            this.saveUpdateRecord(reconciliationLetter2, ReconciliationLetterOperateType.CONFIRM);
        }
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8fdb\u884c\u5bf9\u8d26\u51fd\u4e1a\u52a1\u64cd\u4f5c\u65f6\uff0c\u4e1a\u52a1\u552f\u4e00\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        this.reconciliationLetterRepository.deleteBatch(ids);
    }

    @Override
    public List<ReconciliationLetterVo> findByTemplateCodes(List<String> templateCodes) {
        if (CollectionUtils.isEmpty(templateCodes)) {
            return null;
        }
        return this.reconciliationLetterRepository.findByTemplateCodes(templateCodes, TenantUtils.getTenantCode());
    }

    private void validateCreate(ReconciliationLetterCreateDto reconciliationLetterCreateDto) {
        Validate.notNull((Object)reconciliationLetterCreateDto, (String)"\u5bf9\u8d26\u51fd\u521b\u5efa\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)reconciliationLetterCreateDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)reconciliationLetterCreateDto.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)reconciliationLetterCreateDto.getReconciliationTemplateCode(), (String)"\u5bf9\u8d26\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)reconciliationLetterCreateDto.getReconciliationTemplateName(), (String)"\u5bf9\u8d26\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)reconciliationLetterCreateDto.getCalculationStartTime(), (String)"\u5bf9\u8d26\u8ba1\u7b97\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)reconciliationLetterCreateDto.getCalculationEndTime(), (String)"\u5bf9\u8d26\u8ba1\u7b97\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List elementCodes = reconciliationLetterCreateDto.getElementCodes();
        Validate.notEmpty((Collection)elementCodes, (String)"\u521b\u5efa\u5bf9\u8d26\u51fd\u65f6\uff0c\u5bf9\u8d26\u8981\u7d20\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    public Page<ReconciliationLetterVo> findByReconciliationLetterPaginationDto(Pageable pageable, ReconciliationLetterPaginationDto dto) {
        LoginUserDetailsForEMS loginUserDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        Page pageResultEmpty = new Page(0L, 0L, 0L);
        if (StringUtils.isBlank((CharSequence)loginUserDetails.getCustomerCode())) {
            return pageResultEmpty;
        }
        dto.setCustomerCode(loginUserDetails.getCustomerCode());
        Date reconciliationLetterMonth = dto.getReconciliationLetterMonth();
        if (!ObjectUtils.isEmpty((Object)reconciliationLetterMonth)) {
            dto.setStartTime(this.getFirstDayOfMonth(reconciliationLetterMonth));
            dto.setEndTime(this.getLastDayOfMonth(reconciliationLetterMonth));
        }
        ArrayList statusList = Lists.newArrayList();
        statusList.add(ReconciliationLetterStatus.WAIT_CUSTOMER_CONFIRMATION);
        statusList.add(ReconciliationLetterStatus.COMPLETED);
        statusList.add(ReconciliationLetterStatus.WAIT_FINANCIAL_REVIEW);
        dto.setReconciliationLetterStatusList((List)statusList);
        return this.findByConditions(pageable, dto);
    }

    @Override
    public Integer findWaitConfirmationCountByCurrentCustomer(ReconciliationLetterPaginationDto dto) {
        LoginUserDetailsForEMS loginUserDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        if (StringUtils.isBlank((CharSequence)loginUserDetails.getCustomerCode())) {
            return 0;
        }
        dto.setCustomerCode(loginUserDetails.getCustomerCode());
        ArrayList statusList = Lists.newArrayList();
        statusList.add(ReconciliationLetterStatus.WAIT_CUSTOMER_CONFIRMATION);
        dto.setReconciliationLetterStatusList((List)statusList);
        return this.reconciliationLetterRepository.findWaitConfirmationCountByCurrentCustomer(dto);
    }

    private Date getFirstDayOfMonth(Date reconciliationLetterMonth) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(reconciliationLetterMonth);
        int firstDay = cal.getMinimum(5);
        cal.set(5, firstDay);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getLastDayOfMonth(Date reconciliationLetterMonth) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(reconciliationLetterMonth);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    private void saveReconciliationLetterContactRecord(ReconciliationLetterContactRecordDto contactRecordDto, ReconciliationLetterOperateType reconciliationLetterOperateType) {
        JSONObject loginUserJson = this.loginUserService.getLoginUserJson();
        ReconciliationContactRecord reconciliationContactRecord = new ReconciliationContactRecord();
        reconciliationContactRecord.setTenantCode(TenantUtils.getTenantCode());
        reconciliationContactRecord.setReconciliationLetterCode(contactRecordDto.getReconciliationLetterCode());
        reconciliationContactRecord.setPostCode(loginUserJson.getString("postCode"));
        reconciliationContactRecord.setPostName(loginUserJson.getString("postName"));
        reconciliationContactRecord.setOrgCode(loginUserJson.getString("orgCode"));
        reconciliationContactRecord.setOrgName(loginUserJson.getString("orgName"));
        reconciliationContactRecord.setReconciliationLetterOperateType(reconciliationLetterOperateType);
        reconciliationContactRecord.setContent(contactRecordDto.getContent());
        this.contactRecordRepository.save((Object)reconciliationContactRecord);
        List fileDtos = contactRecordDto.getFiles();
        if (CollectionUtils.isEmpty((Collection)fileDtos)) {
            return;
        }
        List reconciliationContactRecordFiles = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)fileDtos, ReconciliationLetterContactRecordFileDto.class, ReconciliationContactRecordFile.class, HashSet.class, ArrayList.class, new String[0]);
        for (ReconciliationContactRecordFile reconciliationContactRecordFile : reconciliationContactRecordFiles) {
            reconciliationContactRecordFile.setTenantCode(TenantUtils.getTenantCode());
            reconciliationContactRecordFile.setReconciliationContactRecordId(reconciliationContactRecord.getId());
        }
        this.contactRecordFileRepository.saveBatch(reconciliationContactRecordFiles);
    }
}

