/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.internal;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.reconciliation.local.context.reconciliationtemplate.ReconciliationTemplateRangeContext;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationletter.ReconciliationLetterVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationCalculationTaskService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateVoService;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationCalculationTaskCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationtemplate.ReconciliationTemplateRangeRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateElementVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateRangeVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateVo;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reconciliationCalculationTaskServiceImpl")
public class ReconciliationCalculationTaskServiceImpl
implements ReconciliationCalculationTaskService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationCalculationTaskServiceImpl.class);
    @Autowired(required=false)
    private ReconciliationTemplateVoService templateVoService;
    @Autowired(required=false)
    private ReconciliationTemplateRangeContext rangeContext;
    @Autowired(required=false)
    private ReconciliationLetterVoService letterVoService;

    @Override
    public void handleCalculationTask(ReconciliationCalculationTaskCreateDto calculationTaskCreateDto) {
        Validate.notNull((Object)calculationTaskCreateDto, (String)"\u8ba1\u7b97\u5e76\u751f\u6210\u5bf9\u8d26\u51fd\u65f6\uff0c\u8bf7\u6c42\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        log.info("\u8ba1\u7b97\u5e76\u751f\u6210\u5bf9\u8d26\u51fd\uff0c\u8bf7\u6c42\u5185\u5bb9:{}", (Object)JsonUtils.obj2JsonString((Object)calculationTaskCreateDto));
        ReconciliationTemplateVo reconciliationTemplateVo = this.templateVoService.findDetailsByCode(calculationTaskCreateDto.getReconciliationTemplateCode());
        Validate.notNull((Object)reconciliationTemplateVo, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5bf9\u8d26\u89c4\u5219\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(reconciliationTemplateVo.getEnableStatus()), (String)"\u5bf9\u8d26\u89c4\u5219\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u751f\u6210\u5bf9\u5e94\u7684\u5bf9\u8d26\u51fd\uff01", (Object[])new Object[0]);
        List elements = reconciliationTemplateVo.getElements();
        Validate.notEmpty((Collection)elements, (String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u8d26\u89c4\u5219\u5bf9\u5e94\u7684\u5bf9\u8d26\u8981\u7d20\u6570\u636e", (Object[])new Object[0]);
        List ranges = reconciliationTemplateVo.getRanges();
        Validate.notEmpty((Collection)ranges, (String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u8d26\u89c4\u5219\u5bf9\u5e94\u7684\u751f\u6548\u8303\u56f4\u6570\u636e", (Object[])new Object[0]);
        Map<String, List<ReconciliationTemplateRangeVo>> rangeDataMap = ranges.stream().collect(Collectors.groupingBy(ReconciliationTemplateRangeVo::getRangeType));
        List<ReconciliationLetterCreateDto> letterCreateDtos = rangeDataMap.keySet().stream().map(rangeType -> {
            ReconciliationTemplateRangeRegister rangeRegister = this.rangeContext.getRangeRegisterByCode((String)rangeType);
            Validate.notNull((Object)rangeRegister, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7c7b\u578b\u7684\u751f\u6548\u8303\u56f4\u6ce8\u518c\u5668", (Object[])new Object[0]);
            List reconciliationTemplateRangeVos = (List)rangeDataMap.get(rangeType);
            return rangeRegister.getCustomerInfoByDataCodes(reconciliationTemplateRangeVos.stream().map(ReconciliationTemplateRangeVo::getDataCode).collect(Collectors.toList()));
        }).flatMap(Collection::stream).distinct().map(customerInfoVo -> {
            ReconciliationLetterCreateDto reconciliationLetterCreateDto = new ReconciliationLetterCreateDto();
            reconciliationLetterCreateDto.setCustomerCode(customerInfoVo.getCustomerCode());
            reconciliationLetterCreateDto.setCustomerName(customerInfoVo.getCustomerName());
            reconciliationLetterCreateDto.setReconciliationTemplateCode(reconciliationTemplateVo.getReconciliationTemplateCode());
            reconciliationLetterCreateDto.setReconciliationTemplateName(reconciliationTemplateVo.getReconciliationTemplateName());
            reconciliationLetterCreateDto.setElementCodes(elements.stream().map(ReconciliationTemplateElementVo::getElementCode).collect(Collectors.toList()));
            reconciliationLetterCreateDto.setCalculationStartTime(calculationTaskCreateDto.getCalculationStartTime());
            reconciliationLetterCreateDto.setCalculationEndTime(calculationTaskCreateDto.getCalculationEndTime());
            return reconciliationLetterCreateDto;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(letterCreateDtos)) {
            return;
        }
        this.letterVoService.createBatch(letterCreateDtos);
    }
}

