package com.biz.crm.dms.business.reconciliation.local.controller.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-23 20:00.
 */

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.reconciliation.local.context.reconciliationelement.ReconciliationElementContext;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementinfo.ReconciliationElementInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账要素信息控制器
 * @author: Bao Hongbin
 * @create: 2021-12-23 20:00
 **/
@Api(tags = "对账要素信息：ReconciliationElementInfo：获取可用的对账要素信息")
@Slf4j
@RestController
@RequestMapping("/v1/reconciliation/elementinfo")
public class ReconciliationElementInfoController {

  @Autowired(required = false)
  private ReconciliationElementContext elementContext;

  /**
   * 获取所有的对账要素信息
   */
  @ApiOperation(value = "获取所有的对账要素信息")
  @GetMapping("/findAll")
  public Result<List<ReconciliationElementInfoVo>> findAll() {
    try {
      List<ReconciliationElementInfoVo> result = this.elementContext.getAllElementInfo();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
