package com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement;
/**
 * Created by Bao Hongbin on 2021-12-16 20:24.
 */

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.dms.business.reconciliation.sdk.enums.CustomerTransactionDetailsType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @program: crm-dms
 * @description: 客户往来明细对账要素表
 * @author: Bao Hongbin
 * @create: 2021-12-16 20:24
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerTransactionDetail", description = "客户往来明细对账要素表")
@TableName("dms_reconciliation_customer_transaction_detail")
@Entity
@Table(name = "dms_reconciliation_customer_transaction_detail")
@org.hibernate.annotations.Table(appliesTo = "dms_reconciliation_customer_transaction_detail", comment = "对账函头部信息要素表")
public class CustomerTransactionDetail extends ReconciliationElementEntity {

  /**
   * 往来明细类型
   */
  @ApiModelProperty("往来明细类型")
  @TableField(value = "transaction_detail_type")
  @Column(name = "transaction_detail_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 往来明细类型 '")
  private CustomerTransactionDetailsType transactionDetailsType;

  /**
   * 现金金额
   */
  @ApiModelProperty("现金金额")
  @TableField(value = "cash_amount")
  @Column(name = "cash_amount", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 现金金额 '")
  private BigDecimal cashAmount;

  /**
   * 授信金额
   */
  @ApiModelProperty("授信金额")
  @TableField(value = "credit_amount")
  @Column(name = "credit_amount", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 授信金额 '")
  private BigDecimal creditAmount;

  /**
   * 折扣金额
   */
  @ApiModelProperty("折扣金额")
  @TableField(value = "discount_amount")
  @Column(name = "discount_amount", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 折扣金额 '")
  private BigDecimal discountAmount;

  /**
   * 货补金额
   */
  @ApiModelProperty("货补金额")
  @TableField(value = "goods_subsidy__amount")
  @Column(name = "goods_subsidy__amount", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 货补金额 '")
  private BigDecimal goodsSubsidyAmount;

  /**
   * 合计金额
   */
  @ApiModelProperty("合计金额")
  @TableField(value = "total_amount")
  @Column(name = "total_amount", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 合计金额 '")
  private BigDecimal totalAmount;
}
