package com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement;
/**
 * Created by Bao Hongbin on 2021-12-16 19:09.
 */

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @program: crm-dms
 * @description: 对账函头部信息要素表
 * @author: Bao Hongbin
 * @create: 2021-12-16 19:09
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HeaderInformation", description = "对账函头部信息要素表")
@TableName("dms_reconciliation_header_information")
@Entity
@Table(name = "dms_reconciliation_header_information")
@org.hibernate.annotations.Table(appliesTo = "dms_reconciliation_header_information", comment = "对账函头部信息要素表")
public class HeaderInformation extends ReconciliationElementEntity {
  /**
   * 账户余额
   */
  @ApiModelProperty("账户余额")
  @TableField(value = "account_balance")
  @Column(name = "account_balance", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 账户余额 '")
  private BigDecimal accountBalance;

  /**
   * 现金余额
   */
  @ApiModelProperty("现金余额")
  @TableField(value = "cash_balance")
  @Column(name = "cash_balance", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 现金余额 '")
  private BigDecimal cashBalance;

  /**
   * 折扣费用余额
   */
  @ApiModelProperty("折扣费用余额")
  @TableField(value = "discount_expense_balance")
  @Column(name = "discount_expense_balance", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 折扣费用余额 '")
  private BigDecimal discountExpenseBalance;

  /**
   * 货补费用余额
   */
  @ApiModelProperty("货补费用余额")
  @TableField(value = "goods_subsidy_expense_balance")
  @Column(name = "goods_subsidy_expense_balance", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 货补费用余额 '")
  private BigDecimal goodsSubsidyExpenseBalance;

  /**
   * 授信额度
   */
  @ApiModelProperty("授信额度")
  @TableField(value = "credit_limit")
  @Column(name = "credit_limit", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 授信额度 '")
  private BigDecimal creditLimit;

  /**
   * 可用授信额度
   */
  @ApiModelProperty("可用授信额度")
  @TableField(value = "available_credit_limit")
  @Column(name = "available_credit_limit", nullable = false, length = 64, columnDefinition = "DECIMAL(20,4) COMMENT ' 可用授信额度 '")
  private BigDecimal availableCreditLimit;
}
