package com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement;
/**
 * Created by Bao Hongbin on 2021-12-16 19:25.
 */

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.util.Date;

/**
 * @program: crm-dms
 * @description: 对账要素实体基础类
 * @author: Bao Hongbin
 * @create: 2021-12-16 19:25
 **/
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public class ReconciliationElementEntity extends TenantEntity {
  /**
   * 要素编码
   */
  @ApiModelProperty("要素编码")
  @TableField(value = "element_code")
  @Column(name = "element_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 要素编码 '")
  private String elementCode;
  /**
   * 对账函编码
   */
  @ApiModelProperty("对账函编码")
  @TableField(value = "letter_code")
  @Column(name = "letter_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 对账函编码 '")
  private String letterCode;
  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @TableField(value = "customer_code")
  @Column(name = "customer_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客户编码 '")
  private String customerCode;
  /**
   * 计算开始时间
   */
  @ApiModelProperty("计算开始时间")
  @TableField(value = "calculation_start_time")
  @Column(name = "calculation_start_time", nullable = false, length = 20, columnDefinition = "datetime COMMENT '计算开始时间'")
  private Date calculationStartTime;
  /**
   * 计算结束时间
   */
  @ApiModelProperty("计算结束时间")
  @TableField(value = "calculation_end_time")
  @Column(name = "calculation_end_time", nullable = false, length = 20, columnDefinition = "datetime COMMENT '计算结束时间'")
  private Date calculationEndTime;
}
