package com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-18 15:12.
 */

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @program: crm-dms
 * @description: 对账函生成时间表
 * @author: Bao Hongbin
 * @create: 2021-12-18 15:12
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ReconciliationLetterCalculationTime", description = "对账函生成时间表")
@TableName("dms_reconciliation_letter_calculation_time")
@Entity
@Table(name = "dms_reconciliation_letter_calculation_time")
@org.hibernate.annotations.Table(appliesTo = "dms_reconciliation_letter_calculation_time", comment = "对账函计算时间表")
public class ReconciliationLetterCalculationTime extends TenantEntity {
  /**
   * 对账规则（模板）编码
   */
  @ApiModelProperty("对账规则（模板）编码")
  @TableField(value = "reconciliation_template_code")
  @Column(name = "reconciliation_template_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 对账规则（模板）编码 '")
  private String reconciliationTemplateCode;

  /**
   * 计算开始时间
   */
  @ApiModelProperty("计算开始时间")
  @TableField(value = "calculation_start_time")
  @Column(name = "calculation_start_time", nullable = false, length = 20, columnDefinition = "datetime COMMENT '计算开始时间'")
  private Date calculationStartTime;

  /**
   * 计算结束时间
   */
  @ApiModelProperty("计算结束时间")
  @TableField(value = "calculation_end_time")
  @Column(name = "calculation_end_time", nullable = false, length = 20, columnDefinition = "datetime COMMENT '计算结束时间'")
  private Date calculationEndTime;

  /**
   * 计算时间
   */
  @ApiModelProperty("计算时间")
  @TableField(value = "calculation_time")
  @Column(name = "calculation_time", nullable = false, length = 20, columnDefinition = "datetime COMMENT '计算时间'")
  private Date calculationTime;

  /**
   * 任务编号
   */
  @ApiModelProperty("任务编号")
  @TableField(value = "task_code")
  @Column(name = "task_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 任务编号 '")
  private String taskCode;
}
