package com.biz.crm.dms.business.reconciliation.local.mapper.reconciliationletter;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationletter.ReconciliationLetter;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterPaginationDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationletter.ReconciliationLetterVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Created by Bao Hongbin on 2021-12-21 20:43.
 */
public interface ReconciliationLetterMapper extends BaseMapper<ReconciliationLetter> {
  /**
   * 分页条件查询
   *
   * @param page
   * @param dto
   * @param normal
   * @return
   */
  Page<ReconciliationLetterVo> findByConditions(Page<ReconciliationLetterVo> page,
                                                @Param("dto") ReconciliationLetterPaginationDto dto,
                                                @Param("delFlag") DelFlagStatusEnum normal);

  /**
   * 通过id 查询详情
   *
   * @param id
   * @param tenantCode
   * @param normal
   * @return
   */
  ReconciliationLetterVo findDetailsById(@Param("id") String id,
                                         @Param("tenantCode") String tenantCode,
                                         @Param("delFlag") DelFlagStatusEnum normal);

  /**
   * 根据对账规则编码查询对账函信息
   *
   * @param templateCodes
   * @param tenantCode
   * @param delFlag
   * @return
   */
  List<ReconciliationLetterVo> findByTemplateCodes(@Param("templateCodes") List<String> templateCodes,
                                                   @Param("tenantCode") String tenantCode,
                                                   @Param("delFlag") DelFlagStatusEnum delFlag);

  /**
   * 客户-待客户确认对账函数量
   * @param dto
   * @return
   */
  Integer findWaitConfirmationCountByCurrentCustomer(@Param("dto") ReconciliationLetterPaginationDto dto);
}
