package com.biz.crm.dms.business.reconciliation.local.mapper.reconciliationtemplate;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate.ReconciliationTemplate;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplatePaginationDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateVo;
import org.apache.ibatis.annotations.Param;

/**
 * Created by Bao Hongbin on 2021-12-18 16:37.
 */
public interface ReconciliationTemplateMapper extends BaseMapper<ReconciliationTemplate> {

  /**
   * 分页条件查询
   *
   * @param page
   * @param dto
   * @param normal
   * @return
   */
  Page<ReconciliationTemplateVo> findByConditions(Page<ReconciliationTemplateVo> page,
                                                  @Param("dto") ReconciliationTemplatePaginationDto dto,
                                                  @Param("delFlag") DelFlagStatusEnum normal);

  /**
   * 根据id查询对账规则数据
   *
   * @param id
   * @param tenantCode
   * @return
   */
  ReconciliationTemplate findDetailsById(@Param("id") String id,
                                         @Param("tenantCode") String tenantCode,
                                         @Param("delFlag") DelFlagStatusEnum delFlag);
}
