package com.biz.crm.dms.business.reconciliation.local.register.reconciliationelement.internal;
/**
 * Created by Bao Hongbin on 2021-12-17 15:13.
 */

import com.biz.crm.dms.business.costpool.sdk.service.CostPoolAmountStatisticsVoService;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolAmountStatisticsVo;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement.CustomerTransactionDetail;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationelement.CustomerTransactionDetailRepository;
import com.biz.crm.dms.business.reconciliation.sdk.enums.CustomerTransactionDetailsType;
import com.biz.crm.dms.business.reconciliation.sdk.enums.CustomerTransactionPoolType;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationelement.ReconciliationElementRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata.CustomerTransactionDetailsDataVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata.CustomerTransactionRecordDataVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementinfo.ReconciliationElementInfoVo;
import com.bizunited.nebula.common.service.CopyObjectCallback;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @program: crm-dms
 * @description: 对账要素客户往来记录数据注册服务实现
 * @author: Bao Hongbin
 * @create: 2021-12-17 15:13
 **/
@Service("customerTransactionRecordDataVoRegister")
public class CustomerTransactionRecordDataVoRegisterImpl implements ReconciliationElementRegister<CustomerTransactionRecordDataVo>, CopyObjectCallback {

  /**
   * 要素编码
   */
  private static final String ELEMENT_CODE = "customer_transaction_record";

  /**
   * 要素名称
   */
  private static final String ELEMENT_NAME = "客户往来记录";

  /**
   * 要素排序
   */
  private static final Integer ELEMENT_SORT = 2;

  /**
   * 要素备注
   */
  private static final String ELEMENT_REMARKS = "客户往来记录";

  @Autowired(required = false)
  private CustomerTransactionDetailRepository repository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private CostPoolAmountStatisticsVoService costPoolAmountStatisticsVoService;

  @Override
  public ReconciliationElementInfoVo getReconciliationElementInfo() {
    return new ReconciliationElementInfoVo(ELEMENT_CODE, ELEMENT_NAME, ELEMENT_SORT, ELEMENT_REMARKS);
  }

  @Override
  public CustomerTransactionRecordDataVo getByLetterCode(String letterCode,String customerCode) {
    if (StringUtils.isBlank(letterCode)) {
      return null;
    }
    List<CustomerTransactionDetail> customerTransactionDetails = repository.findByLetterCodeAndCustomerCode(customerCode,letterCode, TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(customerTransactionDetails)) {
      return null;
    }
    return buildCustomerTransactionRecordDataVo(customerTransactionDetails);
  }

  @Override
  @Transactional
  public CustomerTransactionRecordDataVo create(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime) {
    Map<String, List<CostPoolAmountStatisticsVo>> stringListMap = costPoolAmountStatisticsVoService.handleAmountStatisticsByCustomerCodeAndDate(customerCode, calculationStartTime, calculationEndTime, "poolType");
    List<CustomerTransactionDetail> customerTransactionDetails =
        Arrays.stream(CustomerTransactionDetailsType.values()).map(type -> {
          //TODO 1.调用接口查询相关数据，目前没有接口，先设置默认值
          CustomerTransactionDetail customerTransactionDetail = new CustomerTransactionDetail();
          customerTransactionDetail.setTenantCode(TenantUtils.getTenantCode());
          customerTransactionDetail.setElementCode(ELEMENT_CODE);
          customerTransactionDetail.setLetterCode(letterCode);
          customerTransactionDetail.setCustomerCode(customerCode);
          customerTransactionDetail.setCalculationStartTime(calculationStartTime);
          customerTransactionDetail.setCalculationEndTime(calculationEndTime);
          customerTransactionDetail.setTransactionDetailsType(type);
          stringListMap.get(CustomerTransactionPoolType.CAPITAL.getKey()).stream().forEach(item -> {if(item.getSummary().equals(type.getKey())){
            customerTransactionDetail.setCashAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
          }});
          if(stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey()) != null) {
            stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey()).stream().forEach(item -> {if(item.getSummary().equals(type.getKey())){
            customerTransactionDetail.setCreditAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
            }});
          }else {
            customerTransactionDetail.setCreditAmount(BigDecimal.ZERO);
          }
          stringListMap.get(CustomerTransactionPoolType.DISCOUNT.getKey()).stream().forEach(item -> {if(item.getSummary().equals(type.getKey())){
            customerTransactionDetail.setDiscountAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
          }});
          stringListMap.get(CustomerTransactionPoolType.REPLENISHMENT.getKey()).stream().forEach(item -> {if(item.getSummary().equals(type.getKey())){
            customerTransactionDetail.setGoodsSubsidyAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
          }});
          customerTransactionDetail.setTotalAmount(customerTransactionDetail.getCashAmount().add(customerTransactionDetail.getCreditAmount()).add(customerTransactionDetail.getDiscountAmount()).add(customerTransactionDetail.getGoodsSubsidyAmount()));
          return customerTransactionDetail;
        }).collect(Collectors.toList());
    //2.保存
    repository.saveBatch(customerTransactionDetails);
    return buildCustomerTransactionRecordDataVo(customerTransactionDetails);
  }

  /**
   * 构建客户往来记录数据vo
   *
   * @param customerTransactionDetails
   * @return
   */
  private CustomerTransactionRecordDataVo buildCustomerTransactionRecordDataVo(List<CustomerTransactionDetail> customerTransactionDetails) {
    List<CustomerTransactionDetailsDataVo> customerTransactionDetailsDataVos =
        (List<CustomerTransactionDetailsDataVo>)
            nebulaToolkitService.copyCollectionByWhiteList(
                customerTransactionDetails, CustomerTransactionDetail.class,
                CustomerTransactionDetailsDataVo.class, HashSet.class, ArrayList.class);
    CustomerTransactionDetail any = customerTransactionDetails.stream().findAny().orElse(new CustomerTransactionDetail());
    CustomerTransactionRecordDataVo customerTransactionRecordDataVo =
        nebulaToolkitService.copyObjectByWhiteList(
            any, CustomerTransactionRecordDataVo.class, HashSet.class, ArrayList.class);
    customerTransactionDetailsDataVos.sort(Comparator.comparing(o -> o.getTransactionDetailsType().getOrder()));
    customerTransactionRecordDataVo.setDetails(customerTransactionDetailsDataVos);
    return customerTransactionRecordDataVo;
  }

  @Override
  @Transactional
  public CustomerTransactionRecordDataVo update(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime) {
    //查询数据
    List<CustomerTransactionDetail> customerTransactionDetails = repository.findByLetterCodeAndCustomerCode(customerCode,letterCode, TenantUtils.getTenantCode());
    Validate.isTrue(CollectionUtils.isNotEmpty(customerTransactionDetails), "找不到对应的对账要素");
    //TODO 2.重新获取相关数据，目前没有相关接口
    Map<String, List<CostPoolAmountStatisticsVo>> stringListMap = costPoolAmountStatisticsVoService.handleAmountStatisticsByCustomerCodeAndDate(customerCode, calculationStartTime, calculationEndTime, "poolType");
    List<CustomerTransactionDetail> list =
            customerTransactionDetails.stream().map(customerTransactionDetail -> {
              customerTransactionDetail.setCalculationStartTime(calculationStartTime);
              customerTransactionDetail.setCalculationEndTime(calculationEndTime);
              stringListMap.get(CustomerTransactionPoolType.CAPITAL.getKey()).stream().forEach(item -> {if(item.getSummary().equals(customerTransactionDetail.getTransactionDetailsType().getKey())){
                customerTransactionDetail.setCashAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
              }});
              stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey()).stream().forEach(item -> {if(item.getSummary().equals(customerTransactionDetail.getTransactionDetailsType().getKey())){
                customerTransactionDetail.setCreditAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
              }});
              stringListMap.get(CustomerTransactionPoolType.DISCOUNT.getKey()).stream().forEach(item -> {if(item.getSummary().equals(customerTransactionDetail.getTransactionDetailsType().getKey())){
                customerTransactionDetail.setDiscountAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
              }});
              stringListMap.get(CustomerTransactionPoolType.REPLENISHMENT.getKey()).stream().forEach(item -> {if(item.getSummary().equals(customerTransactionDetail.getTransactionDetailsType().getKey())){
                customerTransactionDetail.setGoodsSubsidyAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
              }});
              customerTransactionDetail.setTotalAmount(customerTransactionDetail.getCashAmount().add(customerTransactionDetail.getCreditAmount()).add(customerTransactionDetail.getDiscountAmount()).add(customerTransactionDetail.getGoodsSubsidyAmount()));
              return customerTransactionDetail;
            }).collect(Collectors.toList());
    //3.更新
    repository.updateBatchById(list);
    return buildCustomerTransactionRecordDataVo(customerTransactionDetails);
  }

  @Override
  public boolean validate(Class sourceClass, Class targetClass) {
    return CustomerTransactionDetail.class.isAssignableFrom(sourceClass)
        && CustomerTransactionDetailsDataVo.class.isAssignableFrom(targetClass);
  }

  @Override
  public void callback(Class sourceClass, List sourceObjects, Class targetClass, List targetObjects) {
    for (int i = 0; i < sourceObjects.size(); ++i) {
      CustomerTransactionDetail sourceObject = (CustomerTransactionDetail) sourceObjects.get(i);
      CustomerTransactionDetailsDataVo targetObject = (CustomerTransactionDetailsDataVo) targetObjects.get(i);
      targetObject.setTransactionDetailsTypeStr(sourceObject.getTransactionDetailsType().getValue());
    }
  }
}
