package com.biz.crm.dms.business.reconciliation.local.register.reconciliationelement.internal;
/**
 * Created by Bao Hongbin on 2021-12-17 15:12.
 */

import com.biz.crm.dms.business.costpool.sdk.service.CostPoolAmountStatisticsVoService;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolAmountStatisticsVo;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement.HeaderInformation;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationelement.HeaderInformationRepository;
import com.biz.crm.dms.business.reconciliation.sdk.enums.CustomerTransactionDetailsType;
import com.biz.crm.dms.business.reconciliation.sdk.enums.CustomerTransactionPoolType;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationelement.ReconciliationElementRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata.HeaderInformationDataVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementinfo.ReconciliationElementInfoVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @program: crm-dms
 * @description: 对账要素头部信息数据注册服务实现
 * @author: Bao Hongbin
 * @create: 2021-12-17 15:12
 **/
@Service("headerInformationDataVoRegister")
public class HeaderInformationDataVoRegisterImpl implements ReconciliationElementRegister<HeaderInformationDataVo> {

  /**
   * 要素编码
   */
  private static final String ELEMENT_CODE = "header_information";
  /**
   * 要素名称
   */
  private static final String ELEMENT_NAME = "对账函头部信息";
  /**
   * 要素排序
   */
  private static final Integer ELEMENT_SORT = 1;

  /**
   * 要素备注
   */
  private static final String ELEMENT_REMARKS = "对账函头部信息";

  /**
   * 授信额度摘要
   */
  private static final String TOTAL_AMOUNT = "total_amount";

  @Autowired(required = false)
  private HeaderInformationRepository repository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private CostPoolAmountStatisticsVoService costPoolAmountStatisticsVoService;

  @Override
  public ReconciliationElementInfoVo getReconciliationElementInfo() {
    return new ReconciliationElementInfoVo(ELEMENT_CODE, ELEMENT_NAME, ELEMENT_SORT, ELEMENT_REMARKS);
  }

  @Override
  public HeaderInformationDataVo getByLetterCode(String letterCode,String customerCode) {
    if (StringUtils.isBlank(letterCode)) {
      return null;
    }
    HeaderInformation headerInformation = repository.findByLetterCodeAndCustomerCode(customerCode,letterCode, TenantUtils.getTenantCode());
    return nebulaToolkitService.copyObjectByWhiteList(
        headerInformation, HeaderInformationDataVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public HeaderInformationDataVo create(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime) {
    Map<String, List<CostPoolAmountStatisticsVo>> stringListMap = costPoolAmountStatisticsVoService.handleAmountStatisticsByCustomerCodeAndDate(customerCode, calculationStartTime, calculationEndTime, "poolType");
    HeaderInformation headerInformation = new HeaderInformation();
    //TODO 1.调用接口查询相关数据，目前没有接口，先设置默认值
    headerInformation.setTenantCode(TenantUtils.getTenantCode());
    headerInformation.setElementCode(ELEMENT_CODE);
    headerInformation.setLetterCode(letterCode);
    headerInformation.setCustomerCode(customerCode);
    headerInformation.setCalculationStartTime(calculationStartTime);
    headerInformation.setCalculationEndTime(calculationEndTime);
    stringListMap.get(CustomerTransactionPoolType.CAPITAL.getKey()).stream().forEach(item -> {if(item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())){
      headerInformation.setCashBalance(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
    }});
    if(stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey()) != null) {
      stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey()).stream().forEach(item -> {
        if (item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())) {
          headerInformation.setAvailableCreditLimit(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
        }
      });
      stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey()).stream().forEach(item -> {
        if (item.getSummary().equals(TOTAL_AMOUNT)) {
          headerInformation.setCreditLimit(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
        }
      });
    }else {
      headerInformation.setAvailableCreditLimit(BigDecimal.ZERO);
      headerInformation.setCreditLimit(BigDecimal.ZERO);
    }
    stringListMap.get(CustomerTransactionPoolType.DISCOUNT.getKey()).stream().forEach(item -> {if(item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())){
      headerInformation.setDiscountExpenseBalance(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
    }});
    stringListMap.get(CustomerTransactionPoolType.REPLENISHMENT.getKey()).stream().forEach(item -> {if(item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())){
      headerInformation.setGoodsSubsidyExpenseBalance(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
    }});
    headerInformation.setAccountBalance(headerInformation.getCashBalance().add(headerInformation.getAvailableCreditLimit()).add(headerInformation.getDiscountExpenseBalance()).add(headerInformation.getGoodsSubsidyExpenseBalance()));
    //2.保存
    repository.save(headerInformation);
    return nebulaToolkitService.copyObjectByWhiteList(
        headerInformation, HeaderInformationDataVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public HeaderInformationDataVo update(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime) {
    //1.查询
    HeaderInformation headerInformation = repository.findByLetterCodeAndCustomerCode(customerCode,letterCode, TenantUtils.getTenantCode());
    Validate.notNull(headerInformation, "找不到对应的对账要素");
    //TODO 2.重新获取相关数据，目前没有相关接口
    Map<String, List<CostPoolAmountStatisticsVo>> stringListMap = costPoolAmountStatisticsVoService.handleAmountStatisticsByCustomerCodeAndDate(customerCode, calculationStartTime, calculationEndTime, "poolType");
    headerInformation.setCalculationStartTime(calculationStartTime);
    headerInformation.setCalculationEndTime(calculationEndTime);
    Optional.ofNullable(stringListMap.get(CustomerTransactionPoolType.CAPITAL.getKey())).orElse(Lists.newArrayList()).stream().forEach(item -> {if(item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())){
      headerInformation.setCashBalance(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
    }});
    Optional.ofNullable(stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey())).orElse(Lists.newArrayList()).stream().forEach(item -> {if(item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())){
      headerInformation.setAvailableCreditLimit(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
    }});
    Optional.ofNullable(stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey())).orElse(Lists.newArrayList()).stream().forEach(item -> {if(item.getSummary().equals(TOTAL_AMOUNT)){
      headerInformation.setCreditLimit(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
    }});
    Optional.ofNullable(stringListMap.get(CustomerTransactionPoolType.DISCOUNT.getKey())).orElse(Lists.newArrayList()).stream().forEach(item -> {if(item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())){
      headerInformation.setDiscountExpenseBalance(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
    }});
    Optional.ofNullable(stringListMap.get(CustomerTransactionPoolType.REPLENISHMENT.getKey())).orElse(Lists.newArrayList()).stream().forEach(item -> {if(item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())){
      headerInformation.setGoodsSubsidyExpenseBalance(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
    }});
    headerInformation.setAccountBalance(headerInformation.getCashBalance().add(headerInformation.getAvailableCreditLimit()).add(headerInformation.getDiscountExpenseBalance()).add(headerInformation.getGoodsSubsidyExpenseBalance()));
    //3.更新
    repository.updateById(headerInformation);
    return nebulaToolkitService.copyObjectByWhiteList(
        headerInformation, HeaderInformationDataVo.class, HashSet.class, ArrayList.class);
  }
}
