package com.biz.crm.dms.business.reconciliation.local.register.reconciliationelement.internal;
/**
 * Created by Bao Hongbin on 2021-12-17 15:13.
 */

import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement.SignatureColumn;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationelement.SignatureColumnRepository;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationelement.ReconciliationElementRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata.SignatureColumnDataVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementinfo.ReconciliationElementInfoVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;

/**
 * @program: crm-dms
 * @description: 对账要素签署栏数据注册服务实现
 * @author: Bao Hongbin
 * @create: 2021-12-17 15:13
 **/
@Service("signatureColumnDataVoRegister")
public class SignatureColumnDataVoRegisterImpl implements ReconciliationElementRegister<SignatureColumnDataVo> {

  /**
   * 要素编码
   */
  private static final String ELEMENT_CODE = "signature_column";
  /**
   * 要素名称
   */
  private static final String ELEMENT_NAME = "签署栏";
  /**
   * 要素排序
   */
  private static final Integer ELEMENT_SORT = 3;
  /**
   * 要素备注
   */
  private static final String ELEMENT_REMARKS = "签署栏";

  @Value("reconciliation.defaultManufacturerName")
  private String defaultManufacturerName = "默认厂商公司名称";

  @Autowired(required = false)
  private SignatureColumnRepository repository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public ReconciliationElementInfoVo getReconciliationElementInfo() {
    return new ReconciliationElementInfoVo(ELEMENT_CODE, ELEMENT_NAME, ELEMENT_SORT, ELEMENT_REMARKS);
  }

  @Override
  public SignatureColumnDataVo getByLetterCode(String letterCode,String customerCode) {
    if (StringUtils.isBlank(letterCode)) {
      return null;
    }
    SignatureColumn signatureColumn = repository.findByLetterCodeAndCustomerCode(customerCode,letterCode, TenantUtils.getTenantCode());
    return nebulaToolkitService.copyObjectByWhiteList(
        signatureColumn, SignatureColumnDataVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public SignatureColumnDataVo create(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime) {
    //1.获取数据
    SignatureColumn signatureColumn = new SignatureColumn();
    signatureColumn.setTenantCode(TenantUtils.getTenantCode());
    signatureColumn.setElementCode(ELEMENT_CODE);
    signatureColumn.setLetterCode(letterCode);
    signatureColumn.setCustomerCode(customerCode);
    signatureColumn.setCalculationStartTime(calculationStartTime);
    signatureColumn.setCalculationEndTime(calculationEndTime);
    signatureColumn.setManufacturerCode(TenantUtils.getAppCode());
    signatureColumn.setManufacturerName(defaultManufacturerName);
    //2.保存
    repository.save(signatureColumn);
    return nebulaToolkitService.copyObjectByWhiteList(
        signatureColumn, SignatureColumnDataVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public SignatureColumnDataVo update(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime) {
    //1.查询
    SignatureColumn signatureColumn = repository.findByLetterCodeAndCustomerCode(customerCode,letterCode, TenantUtils.getTenantCode());
    Validate.notNull(signatureColumn, "找不到对应的对账要素");
    //2.重新获取相关数据
    signatureColumn.setManufacturerCode(TenantUtils.getAppCode());
    signatureColumn.setManufacturerName(defaultManufacturerName);
    //3.更新
    repository.updateById(signatureColumn);
    return nebulaToolkitService.copyObjectByWhiteList(
        signatureColumn, SignatureColumnDataVo.class, HashSet.class, ArrayList.class);
  }
}
