package com.biz.crm.dms.business.reconciliation.local.register.reconciliationtemplate.internal;
/**
 * Created by Bao Hongbin on 2021-12-21 20:09.
 */

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationtemplate.ReconciliationTemplateRangeRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.ReconciliationTemplateRangeInfo.ReconciliationCustomerInfoVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.ReconciliationTemplateRangeInfo.ReconciliationTemplateRangeInfoVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @program: crm-dms
 * @description: 生效范围：客户类型对应的客户信息注册器实现
 * @author: Bao Hongbin
 * @create: 2021-12-21 20:09
 **/
@Service("customerTypeCustomerInfoVoRegister")
public class CustomerTypeCustomerInfoVoRegisterImpl implements ReconciliationTemplateRangeRegister {
  /**
   * 范围类型
   */
  private static final String RANGE_TYPE = "customer_type_range";

  /**
   * 范围名称
   */
  private static final String RANGE_NAME = "客户类型";

  /**
   * 范围排序
   */
  private static final Integer RANGE_SORT = 4;

  /**
   * 范围备注
   */
  private static final String RANGE_REMARKS = "客户类型范围";

  @Autowired(required = false)
  private CustomerVoService customerVoService;


  @Override
  public ReconciliationTemplateRangeInfoVo getReconciliationRangeInfo() {
    return new ReconciliationTemplateRangeInfoVo(RANGE_TYPE,RANGE_NAME,RANGE_SORT,RANGE_REMARKS);
  }

  @Override
  public List<ReconciliationCustomerInfoVo> getCustomerInfoByDataCodes(List<String> dataCodes) {
    //查询数据
    if (CollectionUtils.isEmpty(dataCodes)) {
      return null;
    }
    List<CustomerVo> customerVos = customerVoService.findByTypes(dataCodes);
    if (CollectionUtils.isEmpty(customerVos)) {
      return null;
    }
    return customerVos.stream().filter(customerVo ->
        //过滤
        EnableStatusEnum.ENABLE.getCode().equals(customerVo.getEnableStatus())&&
            DelFlagStatusEnum.NORMAL.getCode().equals(customerVo.getDelFlag())
    ).map(customerVo ->
        new ReconciliationCustomerInfoVo(customerVo.getCustomerCode(),customerVo.getCustomerName())
    ).collect(Collectors.toList());
  }
}
