package com.biz.crm.dms.business.reconciliation.local.repository.reconciliationelement;
/**
 * Created by Bao Hongbin on 2021-12-17 11:06.
 */

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement.SignatureColumn;
import com.biz.crm.dms.business.reconciliation.local.mapper.reconciliationelement.SignatureColumnMapper;
import org.springframework.stereotype.Component;

/**
 * @program: crm-dms
 * @description: 签署栏对账要素数据库访问类
 * @author: Bao Hongbin
 * @create: 2021-12-17 11:06
 **/
@Component
public class SignatureColumnRepository extends ServiceImpl<SignatureColumnMapper, SignatureColumn> {
  public SignatureColumn findByLetterCode(String letterCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(SignatureColumn::getTenantCode, tenantCode)
        .eq(SignatureColumn::getLetterCode, letterCode).one();
  }

  public SignatureColumn findByLetterCodeAndCustomerCode(String customerCode,String letterCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(SignatureColumn::getTenantCode, tenantCode)
        .eq(SignatureColumn::getCustomerCode,customerCode)
        .eq(SignatureColumn::getLetterCode, letterCode).one();
  }
}
