package com.biz.crm.dms.business.reconciliation.local.repository.reconciliationletter;
/**
 * Created by Bao Hongbin on 2021-12-21 20:47.
 */

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationletter.ReconciliationLetter;
import com.biz.crm.dms.business.reconciliation.local.mapper.reconciliationletter.ReconciliationLetterMapper;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterPaginationDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationletter.ReconciliationLetterVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 *
 **/
@Component
public class ReconciliationLetterRepository extends ServiceImpl<ReconciliationLetterMapper, ReconciliationLetter> {
  /**
   * 查询是否已经存在重复对账函（判重条件：客户编码+对账规则编码+计算开始日期+计算结束日期）
   *
   * @param customerCode               客户编码
   * @param reconciliationTemplateCode 对账规则编码
   * @param calculationStartTime       计算开始日期
   * @param calculationEndTime         计算结束日期
   * @param tenantCode
   * @return
   */
  public ReconciliationLetter findExist(String customerCode,
                                        String reconciliationTemplateCode,
                                        Date calculationStartTime,
                                        Date calculationEndTime, String tenantCode) {
    return this.lambdaQuery()
        .eq(ReconciliationLetter::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ReconciliationLetter::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(ReconciliationLetter::getTenantCode, tenantCode)
        .eq(ReconciliationLetter::getCustomerCode, customerCode)
        .eq(ReconciliationLetter::getReconciliationTemplateCode, reconciliationTemplateCode)
        .eq(ReconciliationLetter::getCalculationStartTime, calculationStartTime)
        .eq(ReconciliationLetter::getCalculationEndTime, calculationEndTime)
        .one();
  }

  /**
   * 通过code查询对账函
   *
   * @param reconciliationLetterCode
   * @param tenantCode
   * @return
   */
  public ReconciliationLetter findByCode(String reconciliationLetterCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(ReconciliationLetter::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ReconciliationLetter::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(ReconciliationLetter::getTenantCode, tenantCode)
        .eq(ReconciliationLetter::getReconciliationLetterCode, reconciliationLetterCode)
        .one();
  }

  /**
   * 批量删除对账函
   *
   * @param ids
   */
  public void deleteBatch(List<String> ids) {
    this.lambdaUpdate()
        .in(ReconciliationLetter::getId, ids)
        .set(ReconciliationLetter::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<ReconciliationLetterVo> findByConditions(Pageable pageable, ReconciliationLetterPaginationDto dto) {
    Page<ReconciliationLetterVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto, DelFlagStatusEnum.NORMAL);
  }

  /**
   * 通过id 查询
   *
   * @param id
   * @param tenantCode
   * @return
   */
  public ReconciliationLetter findById(String id, String tenantCode) {
    return this.lambdaQuery()
        .eq(ReconciliationLetter::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ReconciliationLetter::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .eq(ReconciliationLetter::getTenantCode, tenantCode)
        .eq(ReconciliationLetter::getId, id)
        .one();
  }

  /**
   * 通过id 查询详情
   *
   * @param id
   * @param tenantCode
   * @return
   */
  public ReconciliationLetterVo findDetailsById(String id, String tenantCode) {
    return baseMapper.findDetailsById(id, tenantCode, DelFlagStatusEnum.NORMAL);
  }

  /**
   * 根据对账规则编码查询对账函信息
   *
   * @param templateCodes
   * @param tenantCode
   * @return
   */
  public List<ReconciliationLetterVo> findByTemplateCodes(List<String> templateCodes, String tenantCode) {
    return baseMapper.findByTemplateCodes(templateCodes, tenantCode, DelFlagStatusEnum.NORMAL);
  }

  /**
   * 客户-待客户确认对账函数量
   * @param dto
   * @return
   */
  public Integer findWaitConfirmationCountByCurrentCustomer(ReconciliationLetterPaginationDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.baseMapper.findWaitConfirmationCountByCurrentCustomer(dto);
  }
}
