package com.biz.crm.dms.business.reconciliation.local.repository.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-18 16:52.
 */

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate.ReconciliationTemplateElement;
import com.biz.crm.dms.business.reconciliation.local.mapper.reconciliationtemplate.ReconciliationTemplateElementMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账规则中的对账要素数据库访问类
 * @author: Bao Hongbin
 * @create: 2021-12-18 16:52
 **/
@Component
public class ReconciliationTemplateElementRepository extends ServiceImpl<ReconciliationTemplateElementMapper, ReconciliationTemplateElement> {
  /**
   * 通过对账规则编码查询对账要素
   *
   * @param reconciliationTemplateCode
   * @param tenantCode
   * @return
   */
  public List<ReconciliationTemplateElement> findListByTemplateCode(String reconciliationTemplateCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(ReconciliationTemplateElement::getTenantCode, tenantCode)
        .eq(ReconciliationTemplateElement::getReconciliationTemplateCode, reconciliationTemplateCode)
        .list();
  }

  /**
   * 通过对账规则编码删除对账要素
   *
   * @param reconciliationTemplateCode
   * @param tenantCode
   */
  public void deleteByTemplateCode(String reconciliationTemplateCode, String tenantCode) {
    this.lambdaUpdate()
        .eq(ReconciliationTemplateElement::getTenantCode, tenantCode)
        .eq(ReconciliationTemplateElement::getReconciliationTemplateCode, reconciliationTemplateCode)
        .remove();
  }
}
