package com.biz.crm.dms.business.reconciliation.local.repository.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-18 16:53.
 */

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate.ReconciliationTemplateRange;
import com.biz.crm.dms.business.reconciliation.local.mapper.reconciliationtemplate.ReconciliationTemplateRangeMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账规则生效范围数据库访问类
 * @author: Bao Hongbin
 * @create: 2021-12-18 16:53
 **/
@Component
public class ReconciliationTemplateRangeRepository extends ServiceImpl<ReconciliationTemplateRangeMapper, ReconciliationTemplateRange> {
  /**
   * 通过对账规则编码查询对账生效范围
   *
   * @param reconciliationTemplateCode
   * @param tenantCode
   * @return
   */
  public List<ReconciliationTemplateRange> findListByTemplateCode(String reconciliationTemplateCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(ReconciliationTemplateRange::getTenantCode, tenantCode)
        .eq(ReconciliationTemplateRange::getReconciliationTemplateCode, reconciliationTemplateCode)
        .list();
  }

  /**
   * 通过对账规则编码删除对账生效范围
   *
   * @param reconciliationTemplateCode
   * @param tenantCode
   */
  public void deleteByTemplateCode(String reconciliationTemplateCode, String tenantCode) {
    this.lambdaUpdate()
        .eq(ReconciliationTemplateRange::getTenantCode, tenantCode)
        .eq(ReconciliationTemplateRange::getReconciliationTemplateCode, reconciliationTemplateCode)
        .remove();
  }
}
