package com.biz.crm.dms.business.reconciliation.local.repository.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-18 16:53.
 */

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate.ReconciliationTemplate;
import com.biz.crm.dms.business.reconciliation.local.mapper.reconciliationtemplate.ReconciliationTemplateMapper;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplatePaginationDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateVo;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账规则数据库访问类
 * @author: Bao Hongbin
 * @create: 2021-12-18 16:53
 **/
@Component
public class ReconciliationTemplateRepository extends ServiceImpl<ReconciliationTemplateMapper, ReconciliationTemplate> {

  /**
   * 分页查询
   *
   * @param pageable                            分页参数
   * @param reconciliationTemplatePaginationDto 查询条件
   * @return 对账规则分页数据
   */
  public Page<ReconciliationTemplateVo> findByConditions(Pageable pageable,
                                                         ReconciliationTemplatePaginationDto reconciliationTemplatePaginationDto) {
    Page<ReconciliationTemplateVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, reconciliationTemplatePaginationDto, DelFlagStatusEnum.NORMAL);
  }

  /**
   * 根据id查询对账规则
   *
   * @param id         id
   * @param tenantCode 二级租户编码
   * @return 对账规则数据
   */
  public ReconciliationTemplate findDetailsById(String id, String tenantCode) {
    return this.baseMapper.findDetailsById(id, tenantCode, DelFlagStatusEnum.NORMAL);
  }

  /**
   * 根据名称模糊查询对账规则
   *
   * @param reconciliationTemplateName
   * @param isLike
   * @param tenantCode
   * @return
   */
  public List<ReconciliationTemplate> findListByName(String reconciliationTemplateName, boolean isLike, String tenantCode) {
    return this.lambdaQuery()
        .eq(ReconciliationTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ReconciliationTemplate::getTenantCode, tenantCode)
        .eq(!isLike, ReconciliationTemplate::getReconciliationTemplateName, reconciliationTemplateName)
        .like(isLike, ReconciliationTemplate::getReconciliationTemplateName, reconciliationTemplateName)
        .list();
  }

  /**
   * 根据ids查询对账规则集合
   *
   * @param ids
   * @param tenantCode
   * @return
   */
  public List<ReconciliationTemplate> findListByIds(List<String> ids, String tenantCode) {
    return this.lambdaQuery()
        .eq(ReconciliationTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ReconciliationTemplate::getTenantCode, tenantCode)
        .in(ReconciliationTemplate::getId, ids)
        .list();
  }

  /**
   * 批量禁用
   *
   * @param ids
   */
  public void disableBatch(List<String> ids) {
    this.lambdaUpdate()
        .eq(ReconciliationTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(ReconciliationTemplate::getId, ids)
        .set(ReconciliationTemplate::getEnableStatus, EnableStatusEnum.DISABLE.getCode())
        .update();
  }

  /**
   * 批量启用
   *
   * @param ids
   */
  public void enableBatch(List<String> ids) {
    this.lambdaUpdate()
        .eq(ReconciliationTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(ReconciliationTemplate::getId, ids)
        .set(ReconciliationTemplate::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
        .update();
  }

  /**
   * 批量逻辑删除
   *
   * @param ids
   */
  public void deleteBatch(List<String> ids) {
    this.lambdaUpdate()
        .in(ReconciliationTemplate::getId, ids)
        .set(ReconciliationTemplate::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 根据id查询对账规则
   *
   * @param code       code
   * @param tenantCode 二级租户编码
   * @return 对账规则数据
   */
  public ReconciliationTemplate findDetailsByCode(String code, String tenantCode) {
    return this.lambdaQuery()
        .eq(ReconciliationTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(ReconciliationTemplate::getTenantCode, tenantCode)
        .eq(ReconciliationTemplate::getReconciliationTemplateCode, code)
        .one();
  }
}
