package com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.internal;
/**
 * Created by Bao Hongbin on 2021-12-21 19:19.
 */

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.reconciliation.local.context.reconciliationtemplate.ReconciliationTemplateRangeContext;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationletter.ReconciliationLetterVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationCalculationTaskService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateVoService;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationCalculationTaskCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationtemplate.ReconciliationTemplateRangeRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateElementVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateRangeVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateVo;
import com.bizunited.nebula.common.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @program: crm-dms
 * @description: 计算并生成客户对账函服务
 * @author: Bao Hongbin
 * @create: 2021-12-21 19:19
 **/
@Service("reconciliationCalculationTaskServiceImpl")
@Slf4j
public class ReconciliationCalculationTaskServiceImpl implements ReconciliationCalculationTaskService {
  @Autowired(required = false)
  private ReconciliationTemplateVoService templateVoService;
  @Autowired(required = false)
  private ReconciliationTemplateRangeContext rangeContext;
  @Autowired(required = false)
  private ReconciliationLetterVoService letterVoService;

  /**
   * 1.获取生效范围
   * 2.获取生效范围对应的客户信息
   * 3.将客户信息转换为对账函创建dto
   * 4.生成对应客户的对账函
   *
   * @param calculationTaskCreateDto
   */
  @Override
  public void handleCalculationTask(ReconciliationCalculationTaskCreateDto calculationTaskCreateDto) {
    Validate.notNull(calculationTaskCreateDto, "计算并生成对账函时，请求内容不能为空");
    log.info("计算并生成对账函，请求内容:{}", JsonUtils.obj2JsonString(calculationTaskCreateDto));
    ReconciliationTemplateVo reconciliationTemplateVo =
        templateVoService.findDetailsByCode(calculationTaskCreateDto.getReconciliationTemplateCode());
    Validate.notNull(reconciliationTemplateVo, "无法找到对应的对账规则！");
    Validate.isTrue(EnableStatusEnum.ENABLE.getCode().equals(reconciliationTemplateVo.getEnableStatus()),
        "对账规则已被禁用，无法生成对应的对账函！");
    List<ReconciliationTemplateElementVo> elements = reconciliationTemplateVo.getElements();
    Validate.notEmpty(elements, "无法获取到对账规则对应的对账要素数据");
    //1.获取生效范围
    List<ReconciliationTemplateRangeVo> ranges = reconciliationTemplateVo.getRanges();
    Validate.notEmpty(ranges, "无法获取到对账规则对应的生效范围数据");
    Map<String, List<ReconciliationTemplateRangeVo>> rangeDataMap =
        ranges.stream().collect(Collectors.groupingBy(ReconciliationTemplateRangeVo::getRangeType));
    List<ReconciliationLetterCreateDto> letterCreateDtos =
        rangeDataMap.keySet().stream().map(rangeType -> {
          //2.获取生效范围对应的客户信息
          ReconciliationTemplateRangeRegister rangeRegister = rangeContext.getRangeRegisterByCode(rangeType);
          Validate.notNull(rangeRegister, "找不到对应类型的生效范围注册器");
          List<ReconciliationTemplateRangeVo> reconciliationTemplateRangeVos = rangeDataMap.get(rangeType);
          return rangeRegister.getCustomerInfoByDataCodes(
              reconciliationTemplateRangeVos.stream().map(ReconciliationTemplateRangeVo::getDataCode).collect(Collectors.toList())
          );
        }).flatMap(Collection::stream).distinct().map(customerInfoVo -> {
          //3.将客户信息转换为对账函创建dto
          ReconciliationLetterCreateDto reconciliationLetterCreateDto = new ReconciliationLetterCreateDto();
          reconciliationLetterCreateDto.setCustomerCode(customerInfoVo.getCustomerCode());
          reconciliationLetterCreateDto.setCustomerName(customerInfoVo.getCustomerName());
          reconciliationLetterCreateDto.setReconciliationTemplateCode(reconciliationTemplateVo.getReconciliationTemplateCode());
          reconciliationLetterCreateDto.setReconciliationTemplateName(reconciliationTemplateVo.getReconciliationTemplateName());
          reconciliationLetterCreateDto.setElementCodes(
              elements.stream().map(ReconciliationTemplateElementVo::getElementCode).collect(Collectors.toList()));
          reconciliationLetterCreateDto.setCalculationStartTime(calculationTaskCreateDto.getCalculationStartTime());
          reconciliationLetterCreateDto.setCalculationEndTime(calculationTaskCreateDto.getCalculationEndTime());
          return reconciliationLetterCreateDto;
        }).collect(Collectors.toList());
    //4.生成对应客户的对账函
    if (CollectionUtils.isEmpty(letterCreateDtos)) {
      return;
    }
    letterVoService.createBatch(letterCreateDtos);
  }
}
