package com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.internal;
/**
 * Created by Bao Hongbin on 2021-12-20 16:58.
 */

import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate.ReconciliationTemplateElement;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationtemplate.ReconciliationTemplateElementRepository;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateElementVoService;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateElementCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateElementUpdateDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateElementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

/**
 * @program: crm-dms
 * @description:
 * @author: Bao Hongbin
 * @create: 2021-12-20 16:58
 **/
@Slf4j
@Service
public class ReconciliationTemplateElementVoServiceImpl implements ReconciliationTemplateElementVoService {
  @Autowired(required = false)
  private ReconciliationTemplateElementRepository reconciliationTemplateElementRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<ReconciliationTemplateElementVo> findListByTemplateCode(String reconciliationTemplateCode) {
    List<ReconciliationTemplateElement> elements =
        reconciliationTemplateElementRepository.findListByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
    List<ReconciliationTemplateElementVo> reconciliationTemplateElementVos = (List<ReconciliationTemplateElementVo>) nebulaToolkitService.copyCollectionByWhiteList(elements, ReconciliationTemplateElement.class
        , ReconciliationTemplateElementVo.class, HashSet.class, ArrayList.class);
    reconciliationTemplateElementVos.sort(Comparator.comparing(ReconciliationTemplateElementVo::getSort));
    return reconciliationTemplateElementVos;
  }

  @Override
  @Transactional
  public List<ReconciliationTemplateElementVo> create(String reconciliationTemplateCode, List<ReconciliationTemplateElementCreateDto> elements) {
    //验证
    validateCreate(reconciliationTemplateCode, elements);
    //保存
    List<ReconciliationTemplateElement> reconciliationTemplateElements =
        (List<ReconciliationTemplateElement>) nebulaToolkitService.copyCollectionByWhiteList(elements, ReconciliationTemplateElementCreateDto.class
            , ReconciliationTemplateElement.class, HashSet.class, ArrayList.class);
    return save(reconciliationTemplateCode, reconciliationTemplateElements);
  }

  private void validateCreate(String reconciliationTemplateCode, List<ReconciliationTemplateElementCreateDto> elements) {
    Validate.notBlank(reconciliationTemplateCode, "对账规则编码不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(elements), "新增对账规则要素数据不能为空");
    for (ReconciliationTemplateElementCreateDto elementCreateDto : elements) {
      Validate.notBlank(elementCreateDto.getElementCode(), "对账要素编码不能为空");
      Validate.notBlank(elementCreateDto.getElementName(), "对账要素名称不能为空");
      Validate.notNull(elementCreateDto.getSort(), "对账要素排序不能为空");
    }
  }

  @Override
  @Transactional
  public List<ReconciliationTemplateElementVo> update(String reconciliationTemplateCode, List<ReconciliationTemplateElementUpdateDto> elements) {
    //验证
    validateUpdate(reconciliationTemplateCode, elements);
    //删除数据
    reconciliationTemplateElementRepository.deleteByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
    //保存
    List<ReconciliationTemplateElement> reconciliationTemplateElements =
        (List<ReconciliationTemplateElement>) nebulaToolkitService.copyCollectionByWhiteList(elements, ReconciliationTemplateElementUpdateDto.class
            , ReconciliationTemplateElement.class, HashSet.class, ArrayList.class);
    return save(reconciliationTemplateCode, reconciliationTemplateElements);
  }

  /**
   * 保存
   *
   * @param reconciliationTemplateCode
   * @param reconciliationTemplateElements
   * @return
   */
  private List<ReconciliationTemplateElementVo> save(String reconciliationTemplateCode, List<ReconciliationTemplateElement> reconciliationTemplateElements) {
    reconciliationTemplateElements.forEach(reconciliationTemplateElement -> {
      reconciliationTemplateElement.setTenantCode(TenantUtils.getTenantCode());
      reconciliationTemplateElement.setReconciliationTemplateCode(reconciliationTemplateCode);
    });
    reconciliationTemplateElementRepository.saveBatch(reconciliationTemplateElements);
    //封装返回
    return (List<ReconciliationTemplateElementVo>) nebulaToolkitService.copyCollectionByWhiteList(
        reconciliationTemplateElements,
        ReconciliationTemplateElement.class,
        ReconciliationTemplateElementVo.class,
        HashSet.class, ArrayList.class);
  }

  private void validateUpdate(String reconciliationTemplateCode, List<ReconciliationTemplateElementUpdateDto> elements) {
    Validate.notBlank(reconciliationTemplateCode, "对账规则编码不能为空");
    List<ReconciliationTemplateElement> reconciliationTemplateElements =
        reconciliationTemplateElementRepository.findListByTemplateCode(
            reconciliationTemplateCode, TenantUtils.getTenantCode());
    Validate.notEmpty(reconciliationTemplateElements, "无法找到对账规则对应的对账要素数据");
    Validate.isTrue(CollectionUtils.isNotEmpty(elements), "新增对账规则要素数据不能为空");
    for (ReconciliationTemplateElementUpdateDto elementCreateDto : elements) {
      Validate.notBlank(elementCreateDto.getElementCode(), "对账要素编码不能为空");
      Validate.notBlank(elementCreateDto.getElementName(), "对账要素名称不能为空");
      Validate.notNull(elementCreateDto.getSort(), "对账要素排序不能为空");
    }
  }

}
