package com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.internal;
/**
 * Created by Bao Hongbin on 2021-12-20 15:06.
 */

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate.ReconciliationTemplate;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationtemplate.ReconciliationTemplateRepository;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationletter.ReconciliationLetterVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationLetterCalculationTimeVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateElementVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateRangeVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateVoService;
import com.biz.crm.dms.business.reconciliation.sdk.common.constant.ReconciliationTemplateConstant;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplatePaginationDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateUpdateDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationletter.ReconciliationLetterVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @program: crm-dms
 * @description: 对账规则服务实现
 * @author: Bao Hongbin
 * @create: 2021-12-20 15:06
 **/
@Service("reconciliationTemplateVoServiceImpl")
@Slf4j
public class ReconciliationTemplateVoServiceImpl implements ReconciliationTemplateVoService {

  @Autowired(required = false)
  private ReconciliationTemplateRepository reconciliationTemplateRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private ReconciliationLetterCalculationTimeVoService calculationTimeVoService;
  @Autowired(required = false)
  private ReconciliationTemplateElementVoService elementVoService;
  @Autowired(required = false)
  private ReconciliationTemplateRangeVoService rangeVoService;
  @Autowired(required = false)
  private GenerateCodeService generateCode;
  @Autowired(required = false)
  private ReconciliationLetterVoService reconciliationLetterVoService;

  @Override
  public Page<ReconciliationTemplateVo> findByConditions(Pageable pageable, ReconciliationTemplatePaginationDto reconciliationTemplatePaginationDto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
    reconciliationTemplatePaginationDto = Optional.ofNullable(reconciliationTemplatePaginationDto).orElse(new ReconciliationTemplatePaginationDto());
    reconciliationTemplatePaginationDto.setTenantCode(TenantUtils.getTenantCode());
    return reconciliationTemplateRepository.findByConditions(pageable, reconciliationTemplatePaginationDto);
  }

  @Override
  public ReconciliationTemplateVo findDetailsById(String id) {
    if (!StringUtils.isNotEmpty(id)) {
      return null;
    }
    //查询主表数据
    ReconciliationTemplate template = reconciliationTemplateRepository.findDetailsById(id, TenantUtils.getTenantCode());
    if (Objects.isNull(template)) {
      return null;
    }
    ReconciliationTemplateVo templateVo = nebulaToolkitService.copyObjectByWhiteList(
        template, ReconciliationTemplateVo.class, HashSet.class, ArrayList.class);
    //查询计算时间数据
    templateVo.setCalculationTimes(calculationTimeVoService.findListByTemplateCode(template.getReconciliationTemplateCode()));
    //查询对账要素数据
    templateVo.setElements(elementVoService.findListByTemplateCode(template.getReconciliationTemplateCode()));
    //查询生效范围数据
    templateVo.setRanges(rangeVoService.findListByTemplateCode(template.getReconciliationTemplateCode()));
    return templateVo;
  }

  @Override
  public ReconciliationTemplateVo findDetailsByCode(String code) {
    if (!StringUtils.isNotEmpty(code)) {
      return null;
    }
    //查询主表数据
    ReconciliationTemplate template = reconciliationTemplateRepository.findDetailsByCode(code, TenantUtils.getTenantCode());
    if (Objects.isNull(template)) {
      return null;
    }
    ReconciliationTemplateVo templateVo = nebulaToolkitService.copyObjectByWhiteList(
        template, ReconciliationTemplateVo.class, HashSet.class, ArrayList.class);
    //查询计算时间数据
    templateVo.setCalculationTimes(calculationTimeVoService.findListByTemplateCode(template.getReconciliationTemplateCode()));
    //查询对账要素数据
    templateVo.setElements(elementVoService.findListByTemplateCode(template.getReconciliationTemplateCode()));
    //查询生效范围数据
    templateVo.setRanges(rangeVoService.findListByTemplateCode(template.getReconciliationTemplateCode()));
    return templateVo;
  }

  @Override
  @Transactional
  public ReconciliationTemplateVo create(ReconciliationTemplateCreateDto reconciliationTemplateCreateDto) {
    return this.createForm(reconciliationTemplateCreateDto);
  }

  /**
   * 通过表单验证并创建对账规则
   *
   * @param reconciliationTemplateCreateDto
   * @return
   */
  private ReconciliationTemplateVo createForm(ReconciliationTemplateCreateDto reconciliationTemplateCreateDto) {
    //验证
    validateCreate(reconciliationTemplateCreateDto);
    //设置数据
    ReconciliationTemplate reconciliationTemplate = this.nebulaToolkitService.copyObjectByWhiteList(
        reconciliationTemplateCreateDto, ReconciliationTemplate.class, HashSet.class, ArrayList.class);
    reconciliationTemplate.setTenantCode(TenantUtils.getTenantCode());
    reconciliationTemplate.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    reconciliationTemplate.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    //TODO 各业务编码前缀以前可以在系统设置中进行设置，该功能将在后续改造中实现，先设置为固定默认值
    reconciliationTemplate.setReconciliationTemplateCode(generateCode.generateCode(ReconciliationTemplateConstant.CODE, 1).get(0));
    //保存数据
    reconciliationTemplateRepository.save(reconciliationTemplate);
    ReconciliationTemplateVo templateVo = nebulaToolkitService.copyObjectByWhiteList(
        reconciliationTemplate, ReconciliationTemplateVo.class, HashSet.class, ArrayList.class);
    //保存对账要素
    templateVo.setElements(
        elementVoService.create(reconciliationTemplate.getReconciliationTemplateCode(), reconciliationTemplateCreateDto.getElements()));
    //保存生效范围
    templateVo.setRanges(
        rangeVoService.create(reconciliationTemplate.getReconciliationTemplateCode(), reconciliationTemplateCreateDto.getRanges()));
    //保存计算时间
    templateVo.setCalculationTimes(
            calculationTimeVoService.create(reconciliationTemplate.getReconciliationTemplateCode(), reconciliationTemplateCreateDto.getCalculationTimes()));
    return templateVo;
  }

  /**
   * 验证创建信息
   *
   * @param reconciliationTemplateCreateDto
   */
  private void validateCreate(ReconciliationTemplateCreateDto reconciliationTemplateCreateDto) {
    Validate.notNull(reconciliationTemplateCreateDto, "进行当前操作时，信息对象必须传入!");
    log.info("新增对账规则请求dto：{}", JsonUtils.obj2JsonString(reconciliationTemplateCreateDto));
    Validate.notBlank(reconciliationTemplateCreateDto.getReconciliationTemplateName(), "对账规则名称不能为空");
    Validate.notNull(reconciliationTemplateCreateDto.getValidityStartTime(), "对账规则有效期开始时间不能为空");
    Validate.notNull(reconciliationTemplateCreateDto.getValidityEndTime(), "对账规则有效期结束时间不能为空");
    Validate.notNull(reconciliationTemplateCreateDto.getGenerationCycleType(), "对账规则生成周期类型不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(reconciliationTemplateCreateDto.getCalculationTimes()), "对账规则计算时间数据不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(reconciliationTemplateCreateDto.getElements()), "对账规则要素数据不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(reconciliationTemplateCreateDto.getRanges()), "对账规则生效范围数据不能为空");
    List<ReconciliationTemplate> reconciliationTemplates =
        reconciliationTemplateRepository.findListByName(reconciliationTemplateCreateDto.getReconciliationTemplateName(), false, TenantUtils.getTenantCode());
    Validate.isTrue(CollectionUtils.isEmpty(reconciliationTemplates), "对账规则名称已存在");
    Validate.isTrue(reconciliationTemplateCreateDto.getReconciliationTemplateName().length() < 64,
        "对账规则名称信息，在进行新增时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(reconciliationTemplateCreateDto.getGenerationTime() < 366,
        "对账规则生成时间不能大于366天");
  }

  @Override
  @Transactional
  public ReconciliationTemplateVo update(ReconciliationTemplateUpdateDto reconciliationTemplateUpdateDto) {
    return this.updateForm(reconciliationTemplateUpdateDto);
  }

  /**
   * 通过表单验证并更新对账规则
   *
   * @param reconciliationTemplateUpdateDto
   * @return
   */
  private ReconciliationTemplateVo updateForm(ReconciliationTemplateUpdateDto reconciliationTemplateUpdateDto) {
    validateUpdate(reconciliationTemplateUpdateDto);
    //更新数据
    ReconciliationTemplate reconciliationTemplate = this.nebulaToolkitService.copyObjectByWhiteList(
        reconciliationTemplateUpdateDto, ReconciliationTemplate.class, HashSet.class, ArrayList.class);
    reconciliationTemplateRepository.updateById(reconciliationTemplate);
    //重新查询数据
    reconciliationTemplate = reconciliationTemplateRepository.getById(reconciliationTemplateUpdateDto.getId());
    ReconciliationTemplateVo templateVo = nebulaToolkitService.copyObjectByWhiteList(
        reconciliationTemplate, ReconciliationTemplateVo.class, HashSet.class, ArrayList.class);
    //更新对账要素
    templateVo.setElements(
        elementVoService.update(reconciliationTemplate.getReconciliationTemplateCode(), reconciliationTemplateUpdateDto.getElements()));
    //更新生效范围
    templateVo.setRanges(
        rangeVoService.update(reconciliationTemplate.getReconciliationTemplateCode(), reconciliationTemplateUpdateDto.getRanges()));
    //更新计算时间
    templateVo.setCalculationTimes(
            calculationTimeVoService.update(reconciliationTemplate.getReconciliationTemplateCode(), reconciliationTemplateUpdateDto.getCalculationTimes()));
    return templateVo;
  }

  /**
   * 验证更新信息
   *
   * @param reconciliationTemplateUpdateDto
   */
  private void validateUpdate(ReconciliationTemplateUpdateDto reconciliationTemplateUpdateDto) {
    Validate.notNull(reconciliationTemplateUpdateDto, "进行当前操作时，信息对象必须传入!");
    log.info("更新对账规则请求dto：{}", JsonUtils.obj2JsonString(reconciliationTemplateUpdateDto));
    Validate.notBlank(reconciliationTemplateUpdateDto.getReconciliationTemplateName(), "对账规则名称不能为空");
    Validate.notBlank(reconciliationTemplateUpdateDto.getId(), "修改信息时，对账规则ID不能为空！");
    ReconciliationTemplate reconciliationTemplate =
        reconciliationTemplateRepository.findDetailsById(reconciliationTemplateUpdateDto.getId(), TenantUtils.getTenantCode());
    Validate.notNull(reconciliationTemplate, "无效的业务技术编号信息");
    Validate.notNull(reconciliationTemplateUpdateDto.getValidityStartTime(), "对账规则有效期开始时间不能为空");
    Validate.notNull(reconciliationTemplateUpdateDto.getValidityEndTime(), "对账规则有效期结束时间不能为空");
    Validate.notNull(reconciliationTemplateUpdateDto.getGenerationCycleType(), "对账规则生成周期类型不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(reconciliationTemplateUpdateDto.getCalculationTimes()), "对账规则计算时间数据不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(reconciliationTemplateUpdateDto.getElements()), "对账规则要素数据不能为空");
    Validate.isTrue(CollectionUtils.isNotEmpty(reconciliationTemplateUpdateDto.getRanges()), "对账规则生效范围数据不能为空");
    List<ReconciliationTemplate> reconciliationTemplates =
        reconciliationTemplateRepository.findListByName(
            reconciliationTemplateUpdateDto.getReconciliationTemplateName(), false, TenantUtils.getTenantCode())
            .stream()
            .filter(reconciliationTemplate1 -> !reconciliationTemplate1.getId().equals(reconciliationTemplateUpdateDto.getId()))
            .collect(Collectors.toList());
    Validate.isTrue(CollectionUtils.isEmpty(reconciliationTemplates), "对账规则名称已存在");
    Validate.isTrue(reconciliationTemplateUpdateDto.getReconciliationTemplateName().length() < 64,
        "对账规则名称信息，在进行新增时填入值超过了限定长度(64)，请检查!");
    Validate.isTrue(reconciliationTemplateUpdateDto.getGenerationTime() < 366,
        "对账规则生成时间不能大于366天");
    //判断是否已经生成了对账函，如果已经生成了对账函则不允许删除对账规则
    List<ReconciliationLetterVo> letterVos = reconciliationLetterVoService.findByTemplateCodes(
        Lists.newArrayList(reconciliationTemplate.getReconciliationTemplateCode())
    );
    Validate.isTrue(CollectionUtils.isEmpty(letterVos), "对账规则已经生成了对账函，不允许编辑对账规则");
  }

  @Override
  @Transactional
  public void enableBatch(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    List<ReconciliationTemplate> templates =
        reconciliationTemplateRepository.findListByIds(ids, TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(templates)) {
      return;
    }
    //设置计算的定时任务有效
    List<String> templateCodes =
        templates.stream().map(ReconciliationTemplate::getReconciliationTemplateCode).collect(Collectors.toList());
    calculationTimeVoService.effectiveBatchByTemplateCodes(templateCodes);
    //启用
    reconciliationTemplateRepository.enableBatch(ids);
  }

  @Override
  @Transactional
  public void disableBatch(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    List<ReconciliationTemplate> templates =
        reconciliationTemplateRepository.findListByIds(ids, TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(templates)) {
      return;
    }
    //设置计算的定时任务无效
    List<String> templateCodes =
        templates.stream().map(ReconciliationTemplate::getReconciliationTemplateCode).collect(Collectors.toList());
    calculationTimeVoService.invalidBatchByTemplateCodes(templateCodes);
    //禁用
    reconciliationTemplateRepository.disableBatch(ids);
  }

  @Override
  @Transactional
  public void deleteBatch(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    List<ReconciliationTemplate> templates =
        reconciliationTemplateRepository.findListByIds(ids, TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(templates)) {
      return;
    }
    //判断是否已经生成了对账函，如果已经生成了对账函则不允许删除对账规则
    List<ReconciliationLetterVo> letterVos = reconciliationLetterVoService.findByTemplateCodes(
        templates.stream().map(ReconciliationTemplate::getReconciliationTemplateCode).collect(Collectors.toList()));
    Validate.isTrue(CollectionUtils.isEmpty(letterVos), "对账规则已经生成了对账函，不允许删除对账规则");
    //删除计算的定时任务
    List<String> templateCodes =
        templates.stream().map(ReconciliationTemplate::getReconciliationTemplateCode).collect(Collectors.toList());
    calculationTimeVoService.deleteBatchByTemplateCodes(templateCodes);
    //删除
    reconciliationTemplateRepository.deleteBatch(ids);
  }
}
