/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.reconciliation.local.context.reconciliationelement;

import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationelement.ReconciliationElementRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementinfo.ReconciliationElementInfoVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReconciliationElementContext {
    private static final Map<String, ReconciliationElementInfoVo> ELEMENT_INFO_CACHE = new ConcurrentHashMap<String, ReconciliationElementInfoVo>();
    private static final Map<String, ReconciliationElementRegister> ELEMENT_REGISTERS_CACHE = new ConcurrentHashMap<String, ReconciliationElementRegister>();

    @Autowired(required=false)
    public ReconciliationElementContext(List<ReconciliationElementRegister> elementRegisters) {
        if (CollectionUtils.isNotEmpty(elementRegisters)) {
            for (ReconciliationElementRegister elementRegister : elementRegisters) {
                ReconciliationElementInfoVo reconciliationElementInfoVo = elementRegister.getReconciliationElementInfo();
                Validate.notNull((Object)reconciliationElementInfoVo, (String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u5bf9\u8d26\u8981\u7d20\u6ce8\u518c\u5668\u7684\u57fa\u672c\u4fe1\u606f", (Object[])new Object[0]);
                ELEMENT_INFO_CACHE.put(reconciliationElementInfoVo.getElementCode(), reconciliationElementInfoVo);
                ELEMENT_REGISTERS_CACHE.put(reconciliationElementInfoVo.getElementCode(), elementRegister);
            }
        }
    }

    public List<ReconciliationElementInfoVo> getAllElementInfo() {
        if (CollectionUtils.isEmpty(ELEMENT_INFO_CACHE.values())) {
            return (List)ELEMENT_INFO_CACHE.values();
        }
        ArrayList<ReconciliationElementInfoVo> reconciliationElementInfoVos = new ArrayList<ReconciliationElementInfoVo>(ELEMENT_INFO_CACHE.values());
        reconciliationElementInfoVos.sort(Comparator.comparing(ReconciliationElementInfoVo::getElementSort));
        return reconciliationElementInfoVos;
    }

    public Collection<ReconciliationElementRegister> getAllElementRegister() {
        return ELEMENT_REGISTERS_CACHE.values();
    }

    public ReconciliationElementInfoVo getElementInfoByCode(String elementCode) {
        if (StringUtils.isBlank((CharSequence)elementCode)) {
            return null;
        }
        if (CollectionUtils.isEmpty(ELEMENT_INFO_CACHE.values())) {
            return null;
        }
        return ELEMENT_INFO_CACHE.get(elementCode);
    }

    public ReconciliationElementRegister getElementRegisterByCode(String elementCode) {
        if (StringUtils.isBlank((CharSequence)elementCode)) {
            return null;
        }
        if (CollectionUtils.isEmpty(ELEMENT_REGISTERS_CACHE.values())) {
            return null;
        }
        return ELEMENT_REGISTERS_CACHE.get(elementCode);
    }
}

