/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.reconciliation.local.register.reconciliationelement.internal;

import com.biz.crm.dms.business.costpool.sdk.service.CostPoolAmountStatisticsVoService;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement.CustomerTransactionDetail;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationelement.CustomerTransactionDetailRepository;
import com.biz.crm.dms.business.reconciliation.sdk.enums.CustomerTransactionDetailsType;
import com.biz.crm.dms.business.reconciliation.sdk.enums.CustomerTransactionPoolType;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationelement.ReconciliationElementRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata.CustomerTransactionDetailsDataVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata.CustomerTransactionRecordDataVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementinfo.ReconciliationElementInfoVo;
import com.bizunited.nebula.common.service.CopyObjectCallback;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerTransactionRecordDataVoRegister")
public class CustomerTransactionRecordDataVoRegisterImpl
implements ReconciliationElementRegister<CustomerTransactionRecordDataVo>,
CopyObjectCallback {
    private static final String ELEMENT_CODE = "customer_transaction_record";
    private static final String ELEMENT_NAME = "\u5ba2\u6237\u5f80\u6765\u8bb0\u5f55";
    private static final Integer ELEMENT_SORT = 2;
    private static final String ELEMENT_REMARKS = "\u5ba2\u6237\u5f80\u6765\u8bb0\u5f55";
    @Autowired(required=false)
    private CustomerTransactionDetailRepository repository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CostPoolAmountStatisticsVoService costPoolAmountStatisticsVoService;

    public ReconciliationElementInfoVo getReconciliationElementInfo() {
        return new ReconciliationElementInfoVo(ELEMENT_CODE, "\u5ba2\u6237\u5f80\u6765\u8bb0\u5f55", ELEMENT_SORT, "\u5ba2\u6237\u5f80\u6765\u8bb0\u5f55");
    }

    public CustomerTransactionRecordDataVo getByLetterCode(String letterCode, String customerCode) {
        if (StringUtils.isBlank((CharSequence)letterCode)) {
            return null;
        }
        List<CustomerTransactionDetail> customerTransactionDetails = this.repository.findByLetterCodeAndCustomerCode(customerCode, letterCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(customerTransactionDetails)) {
            return null;
        }
        return this.buildCustomerTransactionRecordDataVo(customerTransactionDetails);
    }

    @Transactional
    public CustomerTransactionRecordDataVo create(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime) {
        Map stringListMap = this.costPoolAmountStatisticsVoService.handleAmountStatisticsByCustomerCodeAndDate(customerCode, calculationStartTime, calculationEndTime, "poolType");
        List<CustomerTransactionDetail> customerTransactionDetails = Arrays.stream(CustomerTransactionDetailsType.values()).map(type -> {
            CustomerTransactionDetail customerTransactionDetail = new CustomerTransactionDetail();
            customerTransactionDetail.setTenantCode(TenantUtils.getTenantCode());
            customerTransactionDetail.setElementCode(ELEMENT_CODE);
            customerTransactionDetail.setLetterCode(letterCode);
            customerTransactionDetail.setCustomerCode(customerCode);
            customerTransactionDetail.setCalculationStartTime(calculationStartTime);
            customerTransactionDetail.setCalculationEndTime(calculationEndTime);
            customerTransactionDetail.setTransactionDetailsType((CustomerTransactionDetailsType)type);
            ((List)stringListMap.get(CustomerTransactionPoolType.CAPITAL.getKey())).stream().forEach(item -> {
                if (item.getSummary().equals(type.getKey())) {
                    customerTransactionDetail.setCashAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
                }
            });
            if (stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey()) != null) {
                ((List)stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey())).stream().forEach(item -> {
                    if (item.getSummary().equals(type.getKey())) {
                        customerTransactionDetail.setCreditAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
                    }
                });
            } else {
                customerTransactionDetail.setCreditAmount(BigDecimal.ZERO);
            }
            ((List)stringListMap.get(CustomerTransactionPoolType.DISCOUNT.getKey())).stream().forEach(item -> {
                if (item.getSummary().equals(type.getKey())) {
                    customerTransactionDetail.setDiscountAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
                }
            });
            ((List)stringListMap.get(CustomerTransactionPoolType.REPLENISHMENT.getKey())).stream().forEach(item -> {
                if (item.getSummary().equals(type.getKey())) {
                    customerTransactionDetail.setGoodsSubsidyAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
                }
            });
            customerTransactionDetail.setTotalAmount(customerTransactionDetail.getCashAmount().add(customerTransactionDetail.getCreditAmount()).add(customerTransactionDetail.getDiscountAmount()).add(customerTransactionDetail.getGoodsSubsidyAmount()));
            return customerTransactionDetail;
        }).collect(Collectors.toList());
        this.repository.saveBatch(customerTransactionDetails);
        return this.buildCustomerTransactionRecordDataVo(customerTransactionDetails);
    }

    private CustomerTransactionRecordDataVo buildCustomerTransactionRecordDataVo(List<CustomerTransactionDetail> customerTransactionDetails) {
        List customerTransactionDetailsDataVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(customerTransactionDetails, CustomerTransactionDetail.class, CustomerTransactionDetailsDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        CustomerTransactionDetail any = customerTransactionDetails.stream().findAny().orElse(new CustomerTransactionDetail());
        CustomerTransactionRecordDataVo customerTransactionRecordDataVo = (CustomerTransactionRecordDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)any, CustomerTransactionRecordDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        customerTransactionDetailsDataVos.sort(Comparator.comparing(o -> o.getTransactionDetailsType().getOrder()));
        customerTransactionRecordDataVo.setDetails(customerTransactionDetailsDataVos);
        return customerTransactionRecordDataVo;
    }

    @Transactional
    public CustomerTransactionRecordDataVo update(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime) {
        List<CustomerTransactionDetail> customerTransactionDetails = this.repository.findByLetterCodeAndCustomerCode(customerCode, letterCode, TenantUtils.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(customerTransactionDetails), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5bf9\u8d26\u8981\u7d20", (Object[])new Object[0]);
        Map stringListMap = this.costPoolAmountStatisticsVoService.handleAmountStatisticsByCustomerCodeAndDate(customerCode, calculationStartTime, calculationEndTime, "poolType");
        List list = customerTransactionDetails.stream().map(customerTransactionDetail -> {
            customerTransactionDetail.setCalculationStartTime(calculationStartTime);
            customerTransactionDetail.setCalculationEndTime(calculationEndTime);
            ((List)stringListMap.get(CustomerTransactionPoolType.CAPITAL.getKey())).stream().forEach(item -> {
                if (item.getSummary().equals(customerTransactionDetail.getTransactionDetailsType().getKey())) {
                    customerTransactionDetail.setCashAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
                }
            });
            ((List)stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey())).stream().forEach(item -> {
                if (item.getSummary().equals(customerTransactionDetail.getTransactionDetailsType().getKey())) {
                    customerTransactionDetail.setCreditAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
                }
            });
            ((List)stringListMap.get(CustomerTransactionPoolType.DISCOUNT.getKey())).stream().forEach(item -> {
                if (item.getSummary().equals(customerTransactionDetail.getTransactionDetailsType().getKey())) {
                    customerTransactionDetail.setDiscountAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
                }
            });
            ((List)stringListMap.get(CustomerTransactionPoolType.REPLENISHMENT.getKey())).stream().forEach(item -> {
                if (item.getSummary().equals(customerTransactionDetail.getTransactionDetailsType().getKey())) {
                    customerTransactionDetail.setGoodsSubsidyAmount(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
                }
            });
            customerTransactionDetail.setTotalAmount(customerTransactionDetail.getCashAmount().add(customerTransactionDetail.getCreditAmount()).add(customerTransactionDetail.getDiscountAmount()).add(customerTransactionDetail.getGoodsSubsidyAmount()));
            return customerTransactionDetail;
        }).collect(Collectors.toList());
        this.repository.updateBatchById(list);
        return this.buildCustomerTransactionRecordDataVo(customerTransactionDetails);
    }

    public boolean validate(Class sourceClass, Class targetClass) {
        return CustomerTransactionDetail.class.isAssignableFrom(sourceClass) && CustomerTransactionDetailsDataVo.class.isAssignableFrom(targetClass);
    }

    public void callback(Class sourceClass, List sourceObjects, Class targetClass, List targetObjects) {
        for (int i = 0; i < sourceObjects.size(); ++i) {
            CustomerTransactionDetail sourceObject = (CustomerTransactionDetail)((Object)sourceObjects.get(i));
            CustomerTransactionDetailsDataVo targetObject = (CustomerTransactionDetailsDataVo)targetObjects.get(i);
            targetObject.setTransactionDetailsTypeStr(sourceObject.getTransactionDetailsType().getValue());
        }
    }
}

