/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.reconciliation.local.register.reconciliationelement.internal;

import com.biz.crm.dms.business.costpool.sdk.service.CostPoolAmountStatisticsVoService;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationelement.HeaderInformation;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationelement.HeaderInformationRepository;
import com.biz.crm.dms.business.reconciliation.sdk.enums.CustomerTransactionDetailsType;
import com.biz.crm.dms.business.reconciliation.sdk.enums.CustomerTransactionPoolType;
import com.biz.crm.dms.business.reconciliation.sdk.register.reconciliationelement.ReconciliationElementRegister;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementdata.HeaderInformationDataVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationelementinfo.ReconciliationElementInfoVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="headerInformationDataVoRegister")
public class HeaderInformationDataVoRegisterImpl
implements ReconciliationElementRegister<HeaderInformationDataVo> {
    private static final String ELEMENT_CODE = "header_information";
    private static final String ELEMENT_NAME = "\u5bf9\u8d26\u51fd\u5934\u90e8\u4fe1\u606f";
    private static final Integer ELEMENT_SORT = 1;
    private static final String ELEMENT_REMARKS = "\u5bf9\u8d26\u51fd\u5934\u90e8\u4fe1\u606f";
    private static final String TOTAL_AMOUNT = "total_amount";
    @Autowired(required=false)
    private HeaderInformationRepository repository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CostPoolAmountStatisticsVoService costPoolAmountStatisticsVoService;

    public ReconciliationElementInfoVo getReconciliationElementInfo() {
        return new ReconciliationElementInfoVo(ELEMENT_CODE, "\u5bf9\u8d26\u51fd\u5934\u90e8\u4fe1\u606f", ELEMENT_SORT, "\u5bf9\u8d26\u51fd\u5934\u90e8\u4fe1\u606f");
    }

    public HeaderInformationDataVo getByLetterCode(String letterCode, String customerCode) {
        if (StringUtils.isBlank((CharSequence)letterCode)) {
            return null;
        }
        HeaderInformation headerInformation = this.repository.findByLetterCodeAndCustomerCode(customerCode, letterCode, TenantUtils.getTenantCode());
        return (HeaderInformationDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)headerInformation, HeaderInformationDataVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public HeaderInformationDataVo create(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime) {
        Map stringListMap = this.costPoolAmountStatisticsVoService.handleAmountStatisticsByCustomerCodeAndDate(customerCode, calculationStartTime, calculationEndTime, "poolType");
        HeaderInformation headerInformation = new HeaderInformation();
        headerInformation.setTenantCode(TenantUtils.getTenantCode());
        headerInformation.setElementCode(ELEMENT_CODE);
        headerInformation.setLetterCode(letterCode);
        headerInformation.setCustomerCode(customerCode);
        headerInformation.setCalculationStartTime(calculationStartTime);
        headerInformation.setCalculationEndTime(calculationEndTime);
        ((List)stringListMap.get(CustomerTransactionPoolType.CAPITAL.getKey())).stream().forEach(item -> {
            if (item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())) {
                headerInformation.setCashBalance(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
            }
        });
        if (stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey()) != null) {
            ((List)stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey())).stream().forEach(item -> {
                if (item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())) {
                    headerInformation.setAvailableCreditLimit(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
                }
            });
            ((List)stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey())).stream().forEach(item -> {
                if (item.getSummary().equals(TOTAL_AMOUNT)) {
                    headerInformation.setCreditLimit(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
                }
            });
        } else {
            headerInformation.setAvailableCreditLimit(BigDecimal.ZERO);
            headerInformation.setCreditLimit(BigDecimal.ZERO);
        }
        ((List)stringListMap.get(CustomerTransactionPoolType.DISCOUNT.getKey())).stream().forEach(item -> {
            if (item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())) {
                headerInformation.setDiscountExpenseBalance(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
            }
        });
        ((List)stringListMap.get(CustomerTransactionPoolType.REPLENISHMENT.getKey())).stream().forEach(item -> {
            if (item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())) {
                headerInformation.setGoodsSubsidyExpenseBalance(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
            }
        });
        headerInformation.setAccountBalance(headerInformation.getCashBalance().add(headerInformation.getAvailableCreditLimit()).add(headerInformation.getDiscountExpenseBalance()).add(headerInformation.getGoodsSubsidyExpenseBalance()));
        this.repository.save((Object)headerInformation);
        return (HeaderInformationDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)headerInformation, HeaderInformationDataVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public HeaderInformationDataVo update(String letterCode, String customerCode, Date calculationStartTime, Date calculationEndTime) {
        HeaderInformation headerInformation = this.repository.findByLetterCodeAndCustomerCode(customerCode, letterCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)headerInformation), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5bf9\u8d26\u8981\u7d20", (Object[])new Object[0]);
        Map stringListMap = this.costPoolAmountStatisticsVoService.handleAmountStatisticsByCustomerCodeAndDate(customerCode, calculationStartTime, calculationEndTime, "poolType");
        headerInformation.setCalculationStartTime(calculationStartTime);
        headerInformation.setCalculationEndTime(calculationEndTime);
        ((List)Optional.ofNullable(stringListMap.get(CustomerTransactionPoolType.CAPITAL.getKey())).orElse(Lists.newArrayList())).stream().forEach(item -> {
            if (item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())) {
                headerInformation.setCashBalance(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
            }
        });
        ((List)Optional.ofNullable(stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey())).orElse(Lists.newArrayList())).stream().forEach(item -> {
            if (item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())) {
                headerInformation.setAvailableCreditLimit(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
            }
        });
        ((List)Optional.ofNullable(stringListMap.get(CustomerTransactionPoolType.CREDIT.getKey())).orElse(Lists.newArrayList())).stream().forEach(item -> {
            if (item.getSummary().equals(TOTAL_AMOUNT)) {
                headerInformation.setCreditLimit(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
            }
        });
        ((List)Optional.ofNullable(stringListMap.get(CustomerTransactionPoolType.DISCOUNT.getKey())).orElse(Lists.newArrayList())).stream().forEach(item -> {
            if (item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())) {
                headerInformation.setDiscountExpenseBalance(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
            }
        });
        ((List)Optional.ofNullable(stringListMap.get(CustomerTransactionPoolType.REPLENISHMENT.getKey())).orElse(Lists.newArrayList())).stream().forEach(item -> {
            if (item.getSummary().equals(CustomerTransactionDetailsType.CLOSING_BALANCE.getKey())) {
                headerInformation.setGoodsSubsidyExpenseBalance(item.getTotalAmount() == null ? BigDecimal.ZERO : item.getTotalAmount());
            }
        });
        headerInformation.setAccountBalance(headerInformation.getCashBalance().add(headerInformation.getAvailableCreditLimit()).add(headerInformation.getDiscountExpenseBalance()).add(headerInformation.getGoodsSubsidyExpenseBalance()));
        this.repository.updateById((Object)headerInformation);
        return (HeaderInformationDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)headerInformation, HeaderInformationDataVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

