/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.internal;

import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate.ReconciliationLetterCalculationTime;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationtemplate.ReconciliationLetterCalculationTimeRepository;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationletter.ReconciliationLetterVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationLetterCalculationTimeVoService;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter.ReconciliationLetterManualCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationCalculationTaskCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterCalculationTimeCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationLetterCalculationTimeUpdateDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationLetterCalculationTimeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerVoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReconciliationLetterCalculationTimeVoServiceImpl
implements ReconciliationLetterCalculationTimeVoService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationLetterCalculationTimeVoServiceImpl.class);
    private final String TASK_CODE_FORMAT = "%s-%s-%s";
    private final String TASK_INVOKE_BEAN_NAME = "reconciliationCalculationTaskServiceImpl";
    private final String TASK_METHOD = "handleCalculationTask";
    private final String TASK_DESC = "\u8ba1\u7b97\u5e76\u751f\u6210\u6307\u5b9a\u5ba2\u6237\u7684\u5bf9\u8d26\u51fd";
    @Autowired(required=false)
    private ReconciliationLetterCalculationTimeRepository reconciliationLetterCalculationTimeRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;
    @Autowired(required=false)
    private ReconciliationLetterVoService reconciliationLetterVoService;

    @Override
    public List<ReconciliationLetterCalculationTimeVo> findListByTemplateCode(String reconciliationTemplateCode) {
        List<ReconciliationLetterCalculationTime> calculationTimes = this.reconciliationLetterCalculationTimeRepository.findListByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(calculationTimes, ReconciliationLetterCalculationTime.class, ReconciliationLetterCalculationTimeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public List<ReconciliationLetterCalculationTimeVo> create(String reconciliationTemplateCode, List<ReconciliationLetterCalculationTimeCreateDto> calculationTimes) {
        this.validateCreate(reconciliationTemplateCode, calculationTimes);
        List reconciliationLetterCalculationTimes = (List)this.nebulaToolkitService.copyCollectionByWhiteList(calculationTimes, ReconciliationLetterCalculationTimeCreateDto.class, ReconciliationLetterCalculationTime.class, HashSet.class, ArrayList.class, new String[0]);
        this.save(reconciliationTemplateCode, reconciliationLetterCalculationTimes);
        this.createTask(reconciliationLetterCalculationTimes);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)reconciliationLetterCalculationTimes, ReconciliationLetterCalculationTime.class, ReconciliationLetterCalculationTimeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void validateCreate(String reconciliationTemplateCode, List<ReconciliationLetterCalculationTimeCreateDto> calculationTimes) {
        Validate.notBlank((CharSequence)reconciliationTemplateCode, (String)"\u5bf9\u8d26\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(calculationTimes), (String)"\u65b0\u589e\u5bf9\u8d26\u89c4\u5219\u8ba1\u7b97\u65f6\u95f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ReconciliationLetterCalculationTimeCreateDto calculationTime : calculationTimes) {
            Validate.notNull((Object)calculationTime.getCalculationEndTime(), (String)"\u5bf9\u8d26\u8ba1\u7b97\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)calculationTime.getCalculationStartTime(), (String)"\u5bf9\u8d26\u8ba1\u7b97\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)calculationTime.getCalculationTime(), (String)"\u5bf9\u8d26\u8ba1\u7b97\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public List<ReconciliationLetterCalculationTimeVo> update(String reconciliationTemplateCode, List<ReconciliationLetterCalculationTimeUpdateDto> calculationTimes) {
        this.validateUpdate(reconciliationTemplateCode, calculationTimes);
        this.delete(reconciliationTemplateCode);
        List reconciliationLetterCalculationTimes = (List)this.nebulaToolkitService.copyCollectionByWhiteList(calculationTimes, ReconciliationLetterCalculationTimeUpdateDto.class, ReconciliationLetterCalculationTime.class, HashSet.class, ArrayList.class, new String[0]);
        this.save(reconciliationTemplateCode, reconciliationLetterCalculationTimes);
        this.createTask(reconciliationLetterCalculationTimes);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)reconciliationLetterCalculationTimes, ReconciliationLetterCalculationTime.class, ReconciliationLetterCalculationTimeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public void invalidBatchByTemplateCodes(List<String> templateCodes) {
        List<ReconciliationLetterCalculationTime> calculationTimes = this.reconciliationLetterCalculationTimeRepository.findListByTemplateCodes(templateCodes, TenantUtils.getTenantCode());
        Validate.notEmpty(calculationTimes, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u8ba1\u7b97\u65f6\u95f4", (Object[])new Object[0]);
        String[] taskCodes = (String[])calculationTimes.stream().map(ReconciliationLetterCalculationTime::getTaskCode).toArray(String[]::new);
        this.dynamicTaskSchedulerVoService.invalid(taskCodes);
    }

    @Override
    @Transactional
    public void effectiveBatchByTemplateCodes(List<String> templateCodes) {
        List<ReconciliationLetterCalculationTime> calculationTimes = this.reconciliationLetterCalculationTimeRepository.findListByTemplateCodes(templateCodes, TenantUtils.getTenantCode());
        Validate.notEmpty(calculationTimes, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u8ba1\u7b97\u65f6\u95f4", (Object[])new Object[0]);
        String[] taskCodes = (String[])calculationTimes.stream().map(ReconciliationLetterCalculationTime::getTaskCode).toArray(String[]::new);
        this.dynamicTaskSchedulerVoService.effective(taskCodes);
    }

    @Override
    @Transactional
    public void deleteBatchByTemplateCodes(List<String> templateCodes) {
        List<ReconciliationLetterCalculationTime> calculationTimes = this.reconciliationLetterCalculationTimeRepository.findListByTemplateCodes(templateCodes, TenantUtils.getTenantCode());
        Validate.notEmpty(calculationTimes, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u8ba1\u7b97\u65f6\u95f4", (Object[])new Object[0]);
        String[] taskCodes = (String[])calculationTimes.stream().map(ReconciliationLetterCalculationTime::getTaskCode).toArray(String[]::new);
        this.dynamicTaskSchedulerVoService.invalid(taskCodes);
        this.dynamicTaskSchedulerVoService.deleteByTaskcodes(taskCodes);
    }

    private void createTask(List<ReconciliationLetterCalculationTime> reconciliationLetterCalculationTimes) {
        List reconciliationCalculationTaskCreateDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(reconciliationLetterCalculationTimes, ReconciliationLetterCalculationTime.class, ReconciliationCalculationTaskCreateDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (ReconciliationCalculationTaskCreateDto reconciliationCalculationTaskCreateDto : reconciliationCalculationTaskCreateDtos) {
            if (reconciliationCalculationTaskCreateDto.getCalculationTime().getTime() < new Date().getTime()) {
                ReconciliationLetterManualCreateDto reconciliationLetterManualCreateDto = new ReconciliationLetterManualCreateDto();
                reconciliationLetterManualCreateDto.setReconciliationTemplateCode(reconciliationCalculationTaskCreateDto.getReconciliationTemplateCode());
                reconciliationLetterManualCreateDto.setCalculationTimeId(reconciliationCalculationTaskCreateDto.getId());
                this.reconciliationLetterVoService.handleManualGenerate(reconciliationLetterManualCreateDto);
                continue;
            }
            this.dynamicTaskSchedulerVoService.createIgnorePrefix(reconciliationCalculationTaskCreateDto.getTaskCode(), "reconciliationCalculationTaskServiceImpl", "handleCalculationTask", Integer.valueOf(1), null, reconciliationCalculationTaskCreateDto.getCalculationTime(), null, "\u8ba1\u7b97\u5e76\u751f\u6210\u6307\u5b9a\u5ba2\u6237\u7684\u5bf9\u8d26\u51fd", new Object[]{reconciliationCalculationTaskCreateDto});
        }
    }

    private void save(String reconciliationTemplateCode, List<ReconciliationLetterCalculationTime> reconciliationLetterCalculationTimes) {
        for (ReconciliationLetterCalculationTime reconciliationLetterCalculationTime : reconciliationLetterCalculationTimes) {
            reconciliationLetterCalculationTime.setTenantCode(TenantUtils.getTenantCode());
            reconciliationLetterCalculationTime.setReconciliationTemplateCode(reconciliationTemplateCode);
            String taskCode = String.format("%s-%s-%s", reconciliationTemplateCode, TenantUtils.getTenantCode(), DateFormatUtils.format((Date)reconciliationLetterCalculationTime.getCalculationTime(), (String)"yyyyMMddHHmmss"));
            reconciliationLetterCalculationTime.setTaskCode(taskCode);
        }
        this.reconciliationLetterCalculationTimeRepository.saveBatch(reconciliationLetterCalculationTimes);
    }

    private void delete(String reconciliationTemplateCode) {
        List<ReconciliationLetterCalculationTime> reconciliationLetterCalculationTimes = this.reconciliationLetterCalculationTimeRepository.findListByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
        String[] taskCodes = (String[])reconciliationLetterCalculationTimes.stream().map(ReconciliationLetterCalculationTime::getTaskCode).toArray(String[]::new);
        this.dynamicTaskSchedulerVoService.invalid(taskCodes);
        this.dynamicTaskSchedulerVoService.deleteByTaskcodes(taskCodes);
        this.reconciliationLetterCalculationTimeRepository.deleteByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
    }

    private void validateUpdate(String reconciliationTemplateCode, List<ReconciliationLetterCalculationTimeUpdateDto> calculationTimes) {
        Validate.notBlank((CharSequence)reconciliationTemplateCode, (String)"\u5bf9\u8d26\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ReconciliationLetterCalculationTime> reconciliationLetterCalculationTimes = this.reconciliationLetterCalculationTimeRepository.findListByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(reconciliationLetterCalculationTimes), (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u8d26\u89c4\u5219\u5bf9\u5e94\u7684\u8ba1\u7b97\u65f6\u95f4\u6570\u636e", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(calculationTimes), (String)"\u66f4\u65b0\u5bf9\u8d26\u89c4\u5219\u8ba1\u7b97\u65f6\u95f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ReconciliationLetterCalculationTimeUpdateDto calculationTime : calculationTimes) {
            Validate.notNull((Object)calculationTime.getCalculationEndTime(), (String)"\u5bf9\u8d26\u8ba1\u7b97\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)calculationTime.getCalculationStartTime(), (String)"\u5bf9\u8d26\u8ba1\u7b97\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)calculationTime.getCalculationTime(), (String)"\u5bf9\u8d26\u8ba1\u7b97\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

