/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.internal;

import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate.ReconciliationTemplateElement;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationtemplate.ReconciliationTemplateElementRepository;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateElementVoService;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateElementCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateElementUpdateDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateElementVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReconciliationTemplateElementVoServiceImpl
implements ReconciliationTemplateElementVoService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationTemplateElementVoServiceImpl.class);
    @Autowired(required=false)
    private ReconciliationTemplateElementRepository reconciliationTemplateElementRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<ReconciliationTemplateElementVo> findListByTemplateCode(String reconciliationTemplateCode) {
        List<ReconciliationTemplateElement> elements = this.reconciliationTemplateElementRepository.findListByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
        List reconciliationTemplateElementVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(elements, ReconciliationTemplateElement.class, ReconciliationTemplateElementVo.class, HashSet.class, ArrayList.class, new String[0]);
        reconciliationTemplateElementVos.sort(Comparator.comparing(ReconciliationTemplateElementVo::getSort));
        return reconciliationTemplateElementVos;
    }

    @Override
    @Transactional
    public List<ReconciliationTemplateElementVo> create(String reconciliationTemplateCode, List<ReconciliationTemplateElementCreateDto> elements) {
        this.validateCreate(reconciliationTemplateCode, elements);
        List reconciliationTemplateElements = (List)this.nebulaToolkitService.copyCollectionByWhiteList(elements, ReconciliationTemplateElementCreateDto.class, ReconciliationTemplateElement.class, HashSet.class, ArrayList.class, new String[0]);
        return this.save(reconciliationTemplateCode, reconciliationTemplateElements);
    }

    private void validateCreate(String reconciliationTemplateCode, List<ReconciliationTemplateElementCreateDto> elements) {
        Validate.notBlank((CharSequence)reconciliationTemplateCode, (String)"\u5bf9\u8d26\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(elements), (String)"\u65b0\u589e\u5bf9\u8d26\u89c4\u5219\u8981\u7d20\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ReconciliationTemplateElementCreateDto elementCreateDto : elements) {
            Validate.notBlank((CharSequence)elementCreateDto.getElementCode(), (String)"\u5bf9\u8d26\u8981\u7d20\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)elementCreateDto.getElementName(), (String)"\u5bf9\u8d26\u8981\u7d20\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)elementCreateDto.getSort(), (String)"\u5bf9\u8d26\u8981\u7d20\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public List<ReconciliationTemplateElementVo> update(String reconciliationTemplateCode, List<ReconciliationTemplateElementUpdateDto> elements) {
        this.validateUpdate(reconciliationTemplateCode, elements);
        this.reconciliationTemplateElementRepository.deleteByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
        List reconciliationTemplateElements = (List)this.nebulaToolkitService.copyCollectionByWhiteList(elements, ReconciliationTemplateElementUpdateDto.class, ReconciliationTemplateElement.class, HashSet.class, ArrayList.class, new String[0]);
        return this.save(reconciliationTemplateCode, reconciliationTemplateElements);
    }

    private List<ReconciliationTemplateElementVo> save(String reconciliationTemplateCode, List<ReconciliationTemplateElement> reconciliationTemplateElements) {
        reconciliationTemplateElements.forEach(reconciliationTemplateElement -> {
            reconciliationTemplateElement.setTenantCode(TenantUtils.getTenantCode());
            reconciliationTemplateElement.setReconciliationTemplateCode(reconciliationTemplateCode);
        });
        this.reconciliationTemplateElementRepository.saveBatch(reconciliationTemplateElements);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(reconciliationTemplateElements, ReconciliationTemplateElement.class, ReconciliationTemplateElementVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void validateUpdate(String reconciliationTemplateCode, List<ReconciliationTemplateElementUpdateDto> elements) {
        Validate.notBlank((CharSequence)reconciliationTemplateCode, (String)"\u5bf9\u8d26\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ReconciliationTemplateElement> reconciliationTemplateElements = this.reconciliationTemplateElementRepository.findListByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
        Validate.notEmpty(reconciliationTemplateElements, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u8d26\u89c4\u5219\u5bf9\u5e94\u7684\u5bf9\u8d26\u8981\u7d20\u6570\u636e", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(elements), (String)"\u65b0\u589e\u5bf9\u8d26\u89c4\u5219\u8981\u7d20\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ReconciliationTemplateElementUpdateDto elementCreateDto : elements) {
            Validate.notBlank((CharSequence)elementCreateDto.getElementCode(), (String)"\u5bf9\u8d26\u8981\u7d20\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)elementCreateDto.getElementName(), (String)"\u5bf9\u8d26\u8981\u7d20\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)elementCreateDto.getSort(), (String)"\u5bf9\u8d26\u8981\u7d20\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

