/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.internal;

import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate.ReconciliationTemplateRange;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationtemplate.ReconciliationTemplateRangeRepository;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateRangeVoService;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateRangeCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateRangeUpdateDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateRangeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReconciliationTemplateRangeVoServiceImpl
implements ReconciliationTemplateRangeVoService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationTemplateRangeVoServiceImpl.class);
    @Autowired(required=false)
    private ReconciliationTemplateRangeRepository reconciliationTemplateRangeRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<ReconciliationTemplateRangeVo> findListByTemplateCode(String reconciliationTemplateCode) {
        List<ReconciliationTemplateRange> ranges = this.reconciliationTemplateRangeRepository.findListByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(ranges, ReconciliationTemplateRange.class, ReconciliationTemplateRangeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional
    public List<ReconciliationTemplateRangeVo> create(String reconciliationTemplateCode, List<ReconciliationTemplateRangeCreateDto> ranges) {
        this.validateCreate(reconciliationTemplateCode, ranges);
        List reconciliationTemplateRanges = (List)this.nebulaToolkitService.copyCollectionByWhiteList(ranges, ReconciliationTemplateRangeCreateDto.class, ReconciliationTemplateRange.class, HashSet.class, ArrayList.class, new String[0]);
        return this.save(reconciliationTemplateCode, reconciliationTemplateRanges);
    }

    private List<ReconciliationTemplateRangeVo> save(String reconciliationTemplateCode, List<ReconciliationTemplateRange> reconciliationTemplateRanges) {
        reconciliationTemplateRanges.forEach(reconciliationTemplateElement -> {
            reconciliationTemplateElement.setTenantCode(TenantUtils.getTenantCode());
            reconciliationTemplateElement.setReconciliationTemplateCode(reconciliationTemplateCode);
        });
        this.reconciliationTemplateRangeRepository.saveBatch(reconciliationTemplateRanges);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(reconciliationTemplateRanges, ReconciliationTemplateRange.class, ReconciliationTemplateRangeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void validateCreate(String reconciliationTemplateCode, List<ReconciliationTemplateRangeCreateDto> ranges) {
        Validate.notBlank((CharSequence)reconciliationTemplateCode, (String)"\u5bf9\u8d26\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ranges), (String)"\u65b0\u589e\u5bf9\u8d26\u89c4\u5219\u751f\u6548\u8303\u56f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ReconciliationTemplateRangeCreateDto rangeCreateDto : ranges) {
            Validate.notBlank((CharSequence)rangeCreateDto.getDataCode(), (String)"\u751f\u6548\u8303\u56f4\u6570\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rangeCreateDto.getDataName(), (String)"\u751f\u6548\u8303\u56f4\u6570\u636e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)rangeCreateDto.getRangeType(), (String)"\u751f\u6548\u8303\u56f4\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public List<ReconciliationTemplateRangeVo> update(String reconciliationTemplateCode, List<ReconciliationTemplateRangeUpdateDto> ranges) {
        this.validateUpdate(reconciliationTemplateCode, ranges);
        this.reconciliationTemplateRangeRepository.deleteByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
        List reconciliationTemplateRanges = (List)this.nebulaToolkitService.copyCollectionByWhiteList(ranges, ReconciliationTemplateRangeUpdateDto.class, ReconciliationTemplateRange.class, HashSet.class, ArrayList.class, new String[0]);
        return this.save(reconciliationTemplateCode, reconciliationTemplateRanges);
    }

    private void validateUpdate(String reconciliationTemplateCode, List<ReconciliationTemplateRangeUpdateDto> rangeUpdateDtos) {
        Validate.notBlank((CharSequence)reconciliationTemplateCode, (String)"\u5bf9\u8d26\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ReconciliationTemplateRange> ranges = this.reconciliationTemplateRangeRepository.findListByTemplateCode(reconciliationTemplateCode, TenantUtils.getTenantCode());
        Validate.notEmpty(ranges, (String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u8d26\u89c4\u5219\u5bf9\u5e94\u7684\u751f\u6548\u8303\u56f4\u6570\u636e", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ranges), (String)"\u65b0\u589e\u5bf9\u8d26\u89c4\u5219\u751f\u6548\u8303\u56f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ReconciliationTemplateRangeUpdateDto rangeUpdateDto : rangeUpdateDtos) {
            Validate.notBlank((CharSequence)rangeUpdateDto.getDataCode(), (String)"\u751f\u6548\u8303\u56f4\u6570\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)rangeUpdateDto.getDataName(), (String)"\u751f\u6548\u8303\u56f4\u6570\u636e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)rangeUpdateDto.getRangeType(), (String)"\u751f\u6548\u8303\u56f4\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

