/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.reconciliation.local.entity.reconciliationtemplate.ReconciliationTemplate;
import com.biz.crm.dms.business.reconciliation.local.repository.reconciliationtemplate.ReconciliationTemplateRepository;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationletter.ReconciliationLetterVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationLetterCalculationTimeVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateElementVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateRangeVoService;
import com.biz.crm.dms.business.reconciliation.local.service.reconciliationtemplate.ReconciliationTemplateVoService;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateCreateDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplatePaginationDto;
import com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate.ReconciliationTemplateUpdateDto;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationletter.ReconciliationLetterVo;
import com.biz.crm.dms.business.reconciliation.sdk.vo.reconciliationtemplate.ReconciliationTemplateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="reconciliationTemplateVoServiceImpl")
public class ReconciliationTemplateVoServiceImpl
implements ReconciliationTemplateVoService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationTemplateVoServiceImpl.class);
    @Autowired(required=false)
    private ReconciliationTemplateRepository reconciliationTemplateRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ReconciliationLetterCalculationTimeVoService calculationTimeVoService;
    @Autowired(required=false)
    private ReconciliationTemplateElementVoService elementVoService;
    @Autowired(required=false)
    private ReconciliationTemplateRangeVoService rangeVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCode;
    @Autowired(required=false)
    private ReconciliationLetterVoService reconciliationLetterVoService;

    @Override
    public Page<ReconciliationTemplateVo> findByConditions(Pageable pageable, ReconciliationTemplatePaginationDto reconciliationTemplatePaginationDto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        reconciliationTemplatePaginationDto = Optional.ofNullable(reconciliationTemplatePaginationDto).orElse(new ReconciliationTemplatePaginationDto());
        reconciliationTemplatePaginationDto.setTenantCode(TenantUtils.getTenantCode());
        return this.reconciliationTemplateRepository.findByConditions(pageable, reconciliationTemplatePaginationDto);
    }

    @Override
    public ReconciliationTemplateVo findDetailsById(String id) {
        if (!StringUtils.isNotEmpty((CharSequence)id)) {
            return null;
        }
        ReconciliationTemplate template = this.reconciliationTemplateRepository.findDetailsById(id, TenantUtils.getTenantCode());
        if (Objects.isNull((Object)template)) {
            return null;
        }
        ReconciliationTemplateVo templateVo = (ReconciliationTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)template, ReconciliationTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        templateVo.setCalculationTimes(this.calculationTimeVoService.findListByTemplateCode(template.getReconciliationTemplateCode()));
        templateVo.setElements(this.elementVoService.findListByTemplateCode(template.getReconciliationTemplateCode()));
        templateVo.setRanges(this.rangeVoService.findListByTemplateCode(template.getReconciliationTemplateCode()));
        return templateVo;
    }

    @Override
    public ReconciliationTemplateVo findDetailsByCode(String code) {
        if (!StringUtils.isNotEmpty((CharSequence)code)) {
            return null;
        }
        ReconciliationTemplate template = this.reconciliationTemplateRepository.findDetailsByCode(code, TenantUtils.getTenantCode());
        if (Objects.isNull((Object)template)) {
            return null;
        }
        ReconciliationTemplateVo templateVo = (ReconciliationTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)template, ReconciliationTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        templateVo.setCalculationTimes(this.calculationTimeVoService.findListByTemplateCode(template.getReconciliationTemplateCode()));
        templateVo.setElements(this.elementVoService.findListByTemplateCode(template.getReconciliationTemplateCode()));
        templateVo.setRanges(this.rangeVoService.findListByTemplateCode(template.getReconciliationTemplateCode()));
        return templateVo;
    }

    @Override
    @Transactional
    public ReconciliationTemplateVo create(ReconciliationTemplateCreateDto reconciliationTemplateCreateDto) {
        return this.createForm(reconciliationTemplateCreateDto);
    }

    private ReconciliationTemplateVo createForm(ReconciliationTemplateCreateDto reconciliationTemplateCreateDto) {
        this.validateCreate(reconciliationTemplateCreateDto);
        ReconciliationTemplate reconciliationTemplate = (ReconciliationTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationTemplateCreateDto, ReconciliationTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        reconciliationTemplate.setTenantCode(TenantUtils.getTenantCode());
        reconciliationTemplate.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        reconciliationTemplate.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        reconciliationTemplate.setReconciliationTemplateCode((String)this.generateCode.generateCode("DZGZ", 1).get(0));
        this.reconciliationTemplateRepository.save((Object)reconciliationTemplate);
        ReconciliationTemplateVo templateVo = (ReconciliationTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationTemplate, ReconciliationTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        templateVo.setElements(this.elementVoService.create(reconciliationTemplate.getReconciliationTemplateCode(), reconciliationTemplateCreateDto.getElements()));
        templateVo.setRanges(this.rangeVoService.create(reconciliationTemplate.getReconciliationTemplateCode(), reconciliationTemplateCreateDto.getRanges()));
        templateVo.setCalculationTimes(this.calculationTimeVoService.create(reconciliationTemplate.getReconciliationTemplateCode(), reconciliationTemplateCreateDto.getCalculationTimes()));
        return templateVo;
    }

    private void validateCreate(ReconciliationTemplateCreateDto reconciliationTemplateCreateDto) {
        Validate.notNull((Object)reconciliationTemplateCreateDto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        log.info("\u65b0\u589e\u5bf9\u8d26\u89c4\u5219\u8bf7\u6c42dto\uff1a{}", (Object)JsonUtils.obj2JsonString((Object)reconciliationTemplateCreateDto));
        Validate.notBlank((CharSequence)reconciliationTemplateCreateDto.getReconciliationTemplateName(), (String)"\u5bf9\u8d26\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)reconciliationTemplateCreateDto.getValidityStartTime(), (String)"\u5bf9\u8d26\u89c4\u5219\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)reconciliationTemplateCreateDto.getValidityEndTime(), (String)"\u5bf9\u8d26\u89c4\u5219\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)reconciliationTemplateCreateDto.getGenerationCycleType(), (String)"\u5bf9\u8d26\u89c4\u5219\u751f\u6210\u5468\u671f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)reconciliationTemplateCreateDto.getCalculationTimes()), (String)"\u5bf9\u8d26\u89c4\u5219\u8ba1\u7b97\u65f6\u95f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)reconciliationTemplateCreateDto.getElements()), (String)"\u5bf9\u8d26\u89c4\u5219\u8981\u7d20\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)reconciliationTemplateCreateDto.getRanges()), (String)"\u5bf9\u8d26\u89c4\u5219\u751f\u6548\u8303\u56f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ReconciliationTemplate> reconciliationTemplates = this.reconciliationTemplateRepository.findListByName(reconciliationTemplateCreateDto.getReconciliationTemplateName(), false, TenantUtils.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(reconciliationTemplates), (String)"\u5bf9\u8d26\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((reconciliationTemplateCreateDto.getReconciliationTemplateName().length() < 64 ? 1 : 0) != 0, (String)"\u5bf9\u8d26\u89c4\u5219\u540d\u79f0\u4fe1\u606f\uff0c\u5728\u8fdb\u884c\u65b0\u589e\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((reconciliationTemplateCreateDto.getGenerationTime() < 366 ? 1 : 0) != 0, (String)"\u5bf9\u8d26\u89c4\u5219\u751f\u6210\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e366\u5929", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public ReconciliationTemplateVo update(ReconciliationTemplateUpdateDto reconciliationTemplateUpdateDto) {
        return this.updateForm(reconciliationTemplateUpdateDto);
    }

    private ReconciliationTemplateVo updateForm(ReconciliationTemplateUpdateDto reconciliationTemplateUpdateDto) {
        this.validateUpdate(reconciliationTemplateUpdateDto);
        ReconciliationTemplate reconciliationTemplate = (ReconciliationTemplate)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationTemplateUpdateDto, ReconciliationTemplate.class, HashSet.class, ArrayList.class, new String[0]));
        this.reconciliationTemplateRepository.updateById((Object)reconciliationTemplate);
        reconciliationTemplate = (ReconciliationTemplate)((Object)this.reconciliationTemplateRepository.getById((Serializable)((Object)reconciliationTemplateUpdateDto.getId())));
        ReconciliationTemplateVo templateVo = (ReconciliationTemplateVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)reconciliationTemplate, ReconciliationTemplateVo.class, HashSet.class, ArrayList.class, new String[0]);
        templateVo.setElements(this.elementVoService.update(reconciliationTemplate.getReconciliationTemplateCode(), reconciliationTemplateUpdateDto.getElements()));
        templateVo.setRanges(this.rangeVoService.update(reconciliationTemplate.getReconciliationTemplateCode(), reconciliationTemplateUpdateDto.getRanges()));
        templateVo.setCalculationTimes(this.calculationTimeVoService.update(reconciliationTemplate.getReconciliationTemplateCode(), reconciliationTemplateUpdateDto.getCalculationTimes()));
        return templateVo;
    }

    private void validateUpdate(ReconciliationTemplateUpdateDto reconciliationTemplateUpdateDto) {
        Validate.notNull((Object)reconciliationTemplateUpdateDto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        log.info("\u66f4\u65b0\u5bf9\u8d26\u89c4\u5219\u8bf7\u6c42dto\uff1a{}", (Object)JsonUtils.obj2JsonString((Object)reconciliationTemplateUpdateDto));
        Validate.notBlank((CharSequence)reconciliationTemplateUpdateDto.getReconciliationTemplateName(), (String)"\u5bf9\u8d26\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)reconciliationTemplateUpdateDto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5bf9\u8d26\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ReconciliationTemplate reconciliationTemplate = this.reconciliationTemplateRepository.findDetailsById(reconciliationTemplateUpdateDto.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)reconciliationTemplate), (String)"\u65e0\u6548\u7684\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notNull((Object)reconciliationTemplateUpdateDto.getValidityStartTime(), (String)"\u5bf9\u8d26\u89c4\u5219\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)reconciliationTemplateUpdateDto.getValidityEndTime(), (String)"\u5bf9\u8d26\u89c4\u5219\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)reconciliationTemplateUpdateDto.getGenerationCycleType(), (String)"\u5bf9\u8d26\u89c4\u5219\u751f\u6210\u5468\u671f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)reconciliationTemplateUpdateDto.getCalculationTimes()), (String)"\u5bf9\u8d26\u89c4\u5219\u8ba1\u7b97\u65f6\u95f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)reconciliationTemplateUpdateDto.getElements()), (String)"\u5bf9\u8d26\u89c4\u5219\u8981\u7d20\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)reconciliationTemplateUpdateDto.getRanges()), (String)"\u5bf9\u8d26\u89c4\u5219\u751f\u6548\u8303\u56f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List reconciliationTemplates = this.reconciliationTemplateRepository.findListByName(reconciliationTemplateUpdateDto.getReconciliationTemplateName(), false, TenantUtils.getTenantCode()).stream().filter(reconciliationTemplate1 -> !reconciliationTemplate1.getId().equals(reconciliationTemplateUpdateDto.getId())).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(reconciliationTemplates), (String)"\u5bf9\u8d26\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((reconciliationTemplateUpdateDto.getReconciliationTemplateName().length() < 64 ? 1 : 0) != 0, (String)"\u5bf9\u8d26\u89c4\u5219\u540d\u79f0\u4fe1\u606f\uff0c\u5728\u8fdb\u884c\u65b0\u589e\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((reconciliationTemplateUpdateDto.getGenerationTime() < 366 ? 1 : 0) != 0, (String)"\u5bf9\u8d26\u89c4\u5219\u751f\u6210\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e366\u5929", (Object[])new Object[0]);
        List<ReconciliationLetterVo> letterVos = this.reconciliationLetterVoService.findByTemplateCodes(Lists.newArrayList((Object[])new String[]{reconciliationTemplate.getReconciliationTemplateCode()}));
        Validate.isTrue((boolean)CollectionUtils.isEmpty(letterVos), (String)"\u5bf9\u8d26\u89c4\u5219\u5df2\u7ecf\u751f\u6210\u4e86\u5bf9\u8d26\u51fd\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u5bf9\u8d26\u89c4\u5219", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<ReconciliationTemplate> templates = this.reconciliationTemplateRepository.findListByIds(ids, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(templates)) {
            return;
        }
        List<String> templateCodes = templates.stream().map(ReconciliationTemplate::getReconciliationTemplateCode).collect(Collectors.toList());
        this.calculationTimeVoService.effectiveBatchByTemplateCodes(templateCodes);
        this.reconciliationTemplateRepository.enableBatch(ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<ReconciliationTemplate> templates = this.reconciliationTemplateRepository.findListByIds(ids, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(templates)) {
            return;
        }
        List<String> templateCodes = templates.stream().map(ReconciliationTemplate::getReconciliationTemplateCode).collect(Collectors.toList());
        this.calculationTimeVoService.invalidBatchByTemplateCodes(templateCodes);
        this.reconciliationTemplateRepository.disableBatch(ids);
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<ReconciliationTemplate> templates = this.reconciliationTemplateRepository.findListByIds(ids, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(templates)) {
            return;
        }
        List<ReconciliationLetterVo> letterVos = this.reconciliationLetterVoService.findByTemplateCodes(templates.stream().map(ReconciliationTemplate::getReconciliationTemplateCode).collect(Collectors.toList()));
        Validate.isTrue((boolean)CollectionUtils.isEmpty(letterVos), (String)"\u5bf9\u8d26\u89c4\u5219\u5df2\u7ecf\u751f\u6210\u4e86\u5bf9\u8d26\u51fd\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u5bf9\u8d26\u89c4\u5219", (Object[])new Object[0]);
        List<String> templateCodes = templates.stream().map(ReconciliationTemplate::getReconciliationTemplateCode).collect(Collectors.toList());
        this.calculationTimeVoService.deleteBatchByTemplateCodes(templateCodes);
        this.reconciliationTemplateRepository.deleteBatch(ids);
    }
}

