package com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationletter;
/**
 * Created by Bao Hongbin on 2021-12-21 20:53.
 */

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账函创建dto
 * @author: Bao Hongbin
 * @create: 2021-12-21 20:53
 **/
@Data
@ApiModel("对账函创建dto")
public class ReconciliationLetterCreateDto {

  /**
   * 对账规则（模板）编码
   */
  @ApiModelProperty("对账规则（模板）编码")
  private String reconciliationTemplateCode;

  /**
   * 对账规则（模板）名称
   */
  @ApiModelProperty("对账规则（模板）名称")
  private String reconciliationTemplateName;

  /**
   * 计算开始时间
   */
  @ApiModelProperty("计算开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date calculationStartTime;

  /**
   * 计算结束时间
   */
  @ApiModelProperty("计算结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date calculationEndTime;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 要素编码集合
   */
  @ApiModelProperty("要素编码集合")
  private List<String> elementCodes;
}
