package com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-20 14:31.
 */

import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @program: crm-dms
 * @description: 对账规则计算定时任务创建dto
 * @author: Bao Hongbin
 * @create: 2021-12-20 14:31
 **/
@Data
@ApiModel("对账规则计算定时任务创建dto")
public class ReconciliationCalculationTaskCreateDto extends UuidDto implements Serializable {
  private static final long serialVersionUID = -1245382460555255323L;

  /**
   * 对账规则（模板）编码
   */
  @ApiModelProperty("对账规则（模板）编码")
  private String reconciliationTemplateCode;

  /**
   * 计算开始时间
   */
  @ApiModelProperty("计算开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date calculationStartTime;

  /**
   * 计算结束时间
   */
  @ApiModelProperty("计算结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date calculationEndTime;

  /**
   * 计算时间
   */
  @ApiModelProperty("计算时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date calculationTime;

  /**
   * 任务编号
   */
  @ApiModelProperty("任务编号")
  private String taskCode;
}
