package com.biz.crm.dms.business.reconciliation.sdk.dto.reconciliationtemplate;
/**
 * Created by Bao Hongbin on 2021-12-20 14:31.
 */

import com.biz.crm.dms.business.reconciliation.sdk.enums.ReconciliationLetterStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @program: crm-dms
 * @description: 对账函分页查询dto
 * @author: Bao Hongbin
 * @create: 2021-12-20 14:31
 **/
@Data
@ApiModel("对账函分页查询dto")
public class ReconciliationLetterPaginationDto {
  /**
   * 租户编号
   */
  private String tenantCode;

  /**
   * 数据状态（删除状态）
   */
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  private String enableStatus;

  /**
   * 对账函编码
   */
  @ApiModelProperty("对账函编码")
  private String reconciliationLetterCode;

  /**
   * 对账月份
   */
  @ApiModelProperty("对账月份")
  @DateTimeFormat(pattern = "yyyy-MM")
  private Date reconciliationLetterMonth;

  /**
   * 查询期间开始时间
   */
  @ApiModelProperty("查询期间开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;
  /**
   * 查询期间结束时间
   */
  @ApiModelProperty("查询期间结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /**
   * 对账函状态
   */
  @ApiModelProperty("对账函状态")
  private ReconciliationLetterStatus reconciliationLetterStatus;

  /**
   * 对账函状态集合
   */
  @ApiModelProperty("对账函状态集合")
  private List<ReconciliationLetterStatus> reconciliationLetterStatusList;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

}
