package com.biz.crm.dms.business.reconciliation.sdk.enums;

/**
 * 对账规则生成周期类型
 * Created by Bao Hongbin on 2021-12-18 11:07.
 */
public enum GenerationCycleType {
  YEAR("year","year", "年度（自然年）", 1),
  QUARTER("quarter","quarter", "季度（自然年）", 2),
  MONTH("month","month", "月度（自然年）", 3),
  FISCAL_YEAR("fiscal_year","fiscal_year", "年度（财年）", 4),
  FISCAL_QUARTER("fiscal_quarter","fiscal_quarter", "季度（财年）", 5),
  FISCAL_MONTH("fiscal_month","fiscal_month", "月度（财年）", 6),
  CUSTOM("custom","custom", "自定义", 7);

  /**
   * key
   */
  private String key;
  /**
   * 编码
   */
  private String dictCode;
  /**
   * 说明
   */
  private String value;
  /**
   * 排序
   */
  private Integer order;

  GenerationCycleType(String key, String dictCode, String value, Integer order) {
    this.key = key;
    this.dictCode = dictCode;
    this.value = value;
    this.order = order;
  }

  /**
   * 根据code转枚举
   *
   * @param dictCode
   * @return
   */
  public static GenerationCycleType codeToEnum(String dictCode) {
    GenerationCycleType result = null;
    for (GenerationCycleType generationCycleType : GenerationCycleType.values()) {
      if (generationCycleType.dictCode.equals(dictCode)) {
        result = generationCycleType;
      }
    }
    return result;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public Integer getOrder() {
    return order;
  }

  public String getValue() {
    return value;
  }
}
